// PluginMain.cpp
//
// This file is part of the REALbasic plugin API.
//
//  1997-2004 REAL Software Inc. -- All Rights Reserved
// See file "Plug-in License SDK.txt" for details.

// If we're using visual studio, we need
// to include winheader++.h
#ifdef _MSC_VER
	#include "winheader++.h"
#endif

#if UNIX_ANSI
	#include <stdlib.h>
#endif

#include "REALplugin.h"

#if TARGET_68K
 	#include <A4Stuff.h>
 	#include <SetupA4.h>
#endif
#include "rb_plugin.h"

#if defined(MPW_CPLUS) || defined(MPW_C)
	#define NOSTATICINIT 1
#endif

#ifdef __GNUC__
	#ifdef __ppc__
		#define powerc 1
	#endif
#endif

#if TARGET_OS_MAC
	#if !defined(powerc) && !defined(__i386__)
		#define USECALLSHELL
	#endif
#endif

#if !FLAT_C_PLUGIN_HEADERS
	#define REALnewInstanceWithClass REALnewInstance
	#define REALGetPropValueInt32 REALGetPropValue
	#define REALGetPropValueString REALGetPropValue
	#define REALGetPropValueDouble REALGetPropValue
	#define REALGetPropValueObject REALGetPropValue
	#define REALGetPropValueUInt8 REALGetPropValue
	#define REALGetPropValueInt64 REALGetPropValue
	#define REALGetPropValueUInt64 REALGetPropValue
	#define REALGetPropValueUInt32 REALGetPropValue
	#define REALGetPropValueUInt16 REALGetPropValue
	#define REALGetPropValueInt16 REALGetPropValue
	#define REALGetPropValueInt8 REALGetPropValue
	#define REALGetPropValueSingle REALGetPropValue
	#define REALSetPropValueInt32 REALSetPropValue
	#define REALSetPropValueString REALSetPropValue
	#define REALSetPropValueDouble REALSetPropValue
	#define REALSetPropValueObject REALSetPropValue
	#define REALSetPropValueUInt8 REALSetPropValue
	#define REALSetPropValueUInt32 REALSetPropValue
	#define REALSetPropValueUInt64 REALSetPropValue
	#define REALSetPropValueInt64 REALSetPropValue
	#define REALSetPropValueInt16 REALSetPropValue
	#define REALSetPropValueUInt16 REALSetPropValue
	#define REALSetPropValueInt8 REALSetPropValue
	#define REALSetPropValueSingle REALSetPropValue

	#define REALGetControlGraphicsWithDC REALGetControlGraphics
	#define REALLockPictureDescriptionWithNativeType	REALLockPictureDescription
#endif

void *(*gResolver)(const char *entryName);

#ifdef powerc
void *(*gResolverPPC)(const char *entryName);
#endif

#ifdef USECALLSHELL
	// static Ptr *gA4Stack;
	static unsigned long a4stack;
#endif

#ifdef powerc
int __procinfo = kThinkCStackBased | STACK_ROUTINE_PARAMETER(1, SIZE_CODE(4));
#endif

static inline void* CallResolver(const char *entryName)
{
	#ifdef powerc
		return gResolverPPC(entryName);
	#else
		return gResolver(entryName);
	#endif
}

static REALmethodDefinition *ConvertCurrentMethodsToV6(REALmethodDefinition *inMethods, long count)
{
	#if TARGET_OS_MAC
		void *newMethods = NewPtr( count * 12 );
	#else
		void *newMethods = malloc( count * 12 );
	#endif
	
	REALmethodDefinition *current = (REALmethodDefinition *)newMethods;
	
	int i;
	for (i = 0; i < count; i++) {
		current->function = inMethods[i].function;
		current->setterFunction = inMethods[i].setterFunction;
		current->declaration = inMethods[i].declaration;
		current = (REALmethodDefinition *)((unsigned long)current + 12);
	}
	
	return (REALmethodDefinition *)newMethods;
}

#ifdef USECALLSHELL
static REALproc buildEnvironmentShell(void *func)
{
	short *glue;
	REALproc proc;
	unsigned long originalCode;
	unsigned long unglue;
	unsigned long pluginA4 = GetCurrentA4();

	static int gRemainAllocCount;
	static Ptr gRemainAllocPtr;

	if (!func)
		return nil;
	if (func == REALstandardGetter)
		return REALstandardGetter;

	originalCode = (unsigned long) func;
	if (!gRemainAllocCount)
	{
		gRemainAllocCount = 8;
		gRemainAllocPtr = NewPtr(8 * 52);
	}
	
	glue = (short *) gRemainAllocPtr;
	gRemainAllocPtr += 52;
	gRemainAllocCount--;
	proc = (REALproc) glue;

	unglue = (unsigned long) (glue + 17);

	*glue++ = 0x2079; // movea.l $, A0
	*glue++ = a4stack >> 16;
	*glue++ = a4stack & 0xffff;
	*glue++ = 0x210c; // move.l A4, -(A0)
	*glue++ = 0x211f; // move.l (A7)+, -(A0)
	*glue++ = 0x287c; // move.l #, A4
	*glue++ = pluginA4 >> 16;
	*glue++ = pluginA4 & 0xffff;
	*glue++ = 0x2f3c; // move.l #, -(A7)
	*glue++ = unglue >> 16;
	*glue++ = unglue & 0xffff;
	*glue++ = 0x23c8; // move.l A0, $
	*glue++ = a4stack >> 16;
	*glue++ = a4stack & 0xffff;
	*glue++ = 0x4ef9; // jmp $
	*glue++ = originalCode >> 16;
	*glue++ = originalCode & 0xffff;

	*glue++ = 0x2279; // movea.l $, A1
	*glue++ = a4stack >> 16;
	*glue++ = a4stack & 0xffff;
	*glue++ = 0x2f19; // move.l (A1)+,-(A7)
	*glue++ = 0x2859; // movea.l (A1)+, A4
	*glue++ = 0x23c9; // move.l A1, $
	*glue++ = a4stack >> 16;
	*glue++ = a4stack & 0xffff;
	*glue++ = 0x4e75; // rts

	return proc;
}
#endif

void SetClassConsoleSafe( REALclassDefinition *def )	// Nov 04 2004 -- AJB (1)
{
	def->mFlags |= REALconsoleSafe;
}

void REALRegisterStructure(REALstructure *defn)
{
	static void (*pRuntimeRegisterMethod)(REALstructure *defn);
	if (!pRuntimeRegisterMethod)
		pRuntimeRegisterMethod = (void (*)(REALstructure *)) CallResolver("PluginRegisterStructure");
	if (pRuntimeRegisterMethod) pRuntimeRegisterMethod(defn);
}

void REALRegisterEnum(REALenum *defn)
{
	static void (*pRuntimeRegisterMethod)(REALenum *defn);
	if (!pRuntimeRegisterMethod)
		pRuntimeRegisterMethod = (void (*)(REALenum *)) CallResolver("PluginRegisterEnum");
	if (pRuntimeRegisterMethod) pRuntimeRegisterMethod(defn);
}

#pragma mark -
#pragma mark PAM Code Below!
#pragma mark -
// **** Autogenerated code from Plugin API Manager follows ****
// *************** Do not edit below this line ****************

#if TARGET_68K || TARGET_PPC
QDGlobals *REALQDGlobals(void)
{
	static unsigned long (*pQDGlobals)(void) = nil;
	if (!pQDGlobals)
		pQDGlobals = (unsigned long (*)(void)) CallResolver("REALQDGlobals");
	if (pQDGlobals) return (QDGlobals *)pQDGlobals();
	else return (QDGlobals *)0;
}
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON
int REALallocateMenuID(void)
{
	static int (*pAllocateMenuID)(void) = nil;
	if (!pAllocateMenuID)
		pAllocateMenuID = (int (*)(void)) CallResolver("allocateMenuID");
	if (pAllocateMenuID) return pAllocateMenuID();
	else return (int)0;
}
#endif

Boolean REALinRuntime(void)
{
	static Boolean (*pInRuntime)(void) = nil;
	if (!pInRuntime)
		pInRuntime = (Boolean (*)(void)) CallResolver("REALinRuntime");
	if (pInRuntime) return pInRuntime();
	else return (Boolean)0;
}

#if TARGET_68K || TARGET_PPC || TARGET_CARBON
void REALreleaseMenuID(int id)
{
	static void (*pReleaseMenuID)(int) = nil;
	if (!pReleaseMenuID)
		pReleaseMenuID = (void (*)(int)) CallResolver("releaseMenuID");
	if (pReleaseMenuID) pReleaseMenuID(id);
}
#endif

void GraphicsDrawLine(REALgraphics graphicsObject, int x1, int y1, int x2, int y2)
{
	static void (*pGraphicsDrawLine)(REALgraphics, int, int, int, int) = nil;
	if (!pGraphicsDrawLine)
		pGraphicsDrawLine = (void (*)(REALgraphics, int, int, int, int)) CallResolver("RuntimeGraphicsDrawLine");
	if (pGraphicsDrawLine) pGraphicsDrawLine(graphicsObject, x1, y1, x2, y2);
}

long REALRegisterBackgroundTask( BackgroundTaskProc proc, unsigned long period, void *data )
{
	static long (*pRuntimeRegisterBackgroundTask)( BackgroundTaskProc, unsigned long, void * );
	if (!pRuntimeRegisterBackgroundTask)
		pRuntimeRegisterBackgroundTask = (long (*)( BackgroundTaskProc, unsigned long, void * )) CallResolver("PluginRegisterBackgroundTask");
	if (pRuntimeRegisterBackgroundTask) return pRuntimeRegisterBackgroundTask( proc, period, data );
	return -1;
}

void REALUnregisterBackgroundTask( long id )
{
	static void (*pRuntimeUnregisterBackgroundTask)( long id );
	if (!pRuntimeUnregisterBackgroundTask)
		pRuntimeUnregisterBackgroundTask = (void (*)(long)) CallResolver("PluginUnregisterBackgroundTask");
	if (pRuntimeUnregisterBackgroundTask) pRuntimeUnregisterBackgroundTask( id );
}

void REALRegisterMethod(REALmethodDefinition *defn)
{
	static void (*pRuntimeRegisterMethod)(REALmethodDefinition *defn);
	if (!pRuntimeRegisterMethod)
		pRuntimeRegisterMethod = (void (*)(REALmethodDefinition *)) CallResolver("PluginRegisterMethod");
	#ifdef USECALLSHELL
	defn->function = buildEnvironmentShell(defn->function);
	defn->setterFunction = buildEnvironmentShell(defn->setterFunction);
	#endif
	if (pRuntimeRegisterMethod) pRuntimeRegisterMethod(defn);
}

void REALRegisterControl(REALcontrol *defn)
{
	static void (*pRuntimeRegisterControl)(REALcontrol *defn);
	if (!pRuntimeRegisterControl)
		pRuntimeRegisterControl = (void (*)(REALcontrol *)) CallResolver("PluginRegisterControl");
	#ifdef USECALLSHELL
	int i;
	for (i = 0; i < defn->propertyCount; i++)
	{
		defn->properties[i].getter = buildEnvironmentShell(defn->properties[i].getter);
		defn->properties[i].setter = buildEnvironmentShell(defn->properties[i].setter);
	}
	for (i = 0; i < defn->methodCount; i++)
	{
		defn->methods[i].function = buildEnvironmentShell(defn->methods[i].function);
		defn->methods[i].setterFunction = buildEnvironmentShell(defn->methods[i].setterFunction);
	}
	defn->behaviour->constructorFunction = (void (*)(REALcontrolInstance)) buildEnvironmentShell(defn->behaviour->constructorFunction);
	defn->behaviour->destructorFunction = (void (*)(REALcontrolInstance)) buildEnvironmentShell(defn->behaviour->destructorFunction);
	defn->behaviour->redrawFunction = (void (*)(REALcontrolInstance)) buildEnvironmentShell(defn->behaviour->redrawFunction);
	defn->behaviour->clickFunction = (Boolean (*)(REALcontrolInstance, int, int, int)) buildEnvironmentShell(defn->behaviour->clickFunction);
	defn->behaviour->mouseDragFunction = (void (*)(REALcontrolInstance, int, int)) buildEnvironmentShell(defn->behaviour->mouseDragFunction);
	defn->behaviour->mouseUpFunction = (void (*)(REALcontrolInstance, int, int)) buildEnvironmentShell(defn->behaviour->mouseUpFunction);
	defn->behaviour->gainedFocusFunction = (void (*)(REALcontrolInstance)) buildEnvironmentShell(defn->behaviour->gainedFocusFunction);
	defn->behaviour->lostFocusFunction = (void (*)(REALcontrolInstance)) buildEnvironmentShell(defn->behaviour->lostFocusFunction);
	defn->behaviour->keyDownFunction = buildEnvironmentShell(defn->behaviour->keyDownFunction);
	defn->behaviour->openFunction = (void (*)(REALcontrolInstance)) buildEnvironmentShell(defn->behaviour->openFunction);
	defn->behaviour->closeFunction = (void (*)(REALcontrolInstance)) buildEnvironmentShell(defn->behaviour->closeFunction);
	defn->behaviour->backgroundIdleFunction = (void (*)(REALcontrolInstance)) buildEnvironmentShell(defn->behaviour->backgroundIdleFunction);
	defn->behaviour->drawOffscreenFunction = (void (*)(REALcontrolInstance, REALgraphics)) buildEnvironmentShell(defn->behaviour->drawOffscreenFunction);
	defn->behaviour->setSpecialBackground = (void (*)(REALcontrolInstance)) buildEnvironmentShell(defn->behaviour->setSpecialBackground);
	defn->behaviour->constantChanging = (void (*)(REALcontrolInstance, REALstring)) buildEnvironmentShell(defn->behaviour->constantChanging);
	defn->behaviour->droppedNewInstance = (void (*)(REALcontrolInstance)) buildEnvironmentShell(defn->behaviour->droppedNewInstance);
	#endif
	
	if (REALGetRBVersion() < 5.9) {
	  defn->methods = ConvertCurrentMethodsToV6( defn->methods, defn->methodCount );
	}
	
	if (pRuntimeRegisterControl) pRuntimeRegisterControl(defn);
}

void REALRegisterClassExtension(REALclassDefinition *defn)
{
	static void (*pRegisterClassExtension)(REALclassDefinition *defn);
	if (!pRegisterClassExtension)
		pRegisterClassExtension = (void (*)(REALclassDefinition *)) CallResolver("PluginRegisterClassExtension");
	#ifdef USECALLSHELL
	int i;
	for (i = 0; i < defn->propertyCount; i++)
	{
		defn->properties[i].getter = buildEnvironmentShell(defn->properties[i].getter);
		defn->properties[i].setter = buildEnvironmentShell(defn->properties[i].setter);
	}
	for (i = 0; i < defn->methodCount; i++)
	{
		defn->methods[i].function = buildEnvironmentShell(defn->methods[i].function);
		defn->methods[i].setterFunction = buildEnvironmentShell(defn->methods[i].setterFunction);
	}
	#endif
	
	if (REALGetRBVersion() < 5.9) {
	  defn->methods = ConvertCurrentMethodsToV6( defn->methods, defn->methodCount );
	}
	
	if (pRegisterClassExtension)
		pRegisterClassExtension(defn);
}

void REALRegisterDBEngine(REALdbEngineDefinition *defn)
{
	static void (*pRegisterDatabaseEngine)(REALdbEngineDefinition *defn);
	if (!pRegisterDatabaseEngine)
		pRegisterDatabaseEngine = (void (*)(REALdbEngineDefinition *)) CallResolver("PluginRegisterDBEngine");
	#ifdef USECALLSHELL
	defn->closeDatabase = (void (*)(dbDatabase *)) buildEnvironmentShell(defn->closeDatabase);
	defn->getTableSchemaCursor = (REALdbCursor (*)(dbDatabase *)) buildEnvironmentShell(defn->getTableSchemaCursor);
	defn->getFieldSchemaCursor = (REALdbCursor (*)(dbDatabase *, REALstring)) buildEnvironmentShell(defn->getFieldSchemaCursor);
	defn->directSQLSelect = (REALdbCursor (*)(dbDatabase *, REALstring)) buildEnvironmentShell(defn->directSQLSelect);
	defn->directSQLExecute = (void (*)(dbDatabase *, REALstring)) buildEnvironmentShell(defn->directSQLExecute);
	defn->createTable = (void (*)(dbDatabase *, REALstring, REALnewColumn *, unsigned char *, int)) buildEnvironmentShell(defn->createTable);
	defn->addTableRecord = (void (*)(dbDatabase *, REALstring, REALcolumnValue *)) buildEnvironmentShell(defn->addTableRecord);
	defn->getTableCursor = (REALdbCursor (*)(dbDatabase *, REALstring, REALgetColumn *, REALcolumnConstraints *)) buildEnvironmentShell(defn->getTableCursor);
	defn->updateFields = (void (*)(dbDatabase *, REALfieldUpdate *)) buildEnvironmentShell(defn->updateFields);
	defn->addTableColumn = (void (*)(dbDatabase *, REALstring, REALnewColumn *)) buildEnvironmentShell(defn->addTableColumn);
	defn->getDatabaseIndexes = (REALdbCursor (*)(dbDatabase *, REALstring)) buildEnvironmentShell(defn->getDatabaseIndexes);
	defn->getLastErrorCode = (long (*)(dbDatabase *)) buildEnvironmentShell(defn->getLastErrorCode);
	defn->getLastErrorString = (REALstring (*)(dbDatabase *)) buildEnvironmentShell(defn->getLastErrorString);
	defn->commit = (void (*)(dbDatabase *)) buildEnvironmentShell(defn->commit);
	defn->rollback = (void (*)(dbDatabase *)) buildEnvironmentShell(defn->rollback);
	defn->getProperty = (REALstring (*)(dbDatabase *, REALstring)) buildEnvironmentShell(defn->getProperty);
	#endif
	if (pRegisterDatabaseEngine)
		pRegisterDatabaseEngine(defn);
}

void REALRegisterDBTable(REALdbTableDefinition *defn)
{
	static void (*pRegisterDBTable)(REALdbTableDefinition *defn);
	if (!pRegisterDBTable)
		pRegisterDBTable = (void (*)(REALdbTableDefinition *)) CallResolver("PluginRegisterDBTable");
	if (pRegisterDBTable)
		pRegisterDBTable(defn);
}

void REALRegisterDBCursor(REALdbCursorDefinition *defn)
{
	static void (*pRegisterDBCursor)(REALdbCursorDefinition *defn);
	if (!pRegisterDBCursor)
		pRegisterDBCursor = (void (*)(REALdbCursorDefinition *)) CallResolver("PluginRegisterDBCursor");
	#ifdef USECALLSHELL
	defn->closeCursor = (void (*)(dbCursor *)) buildEnvironmentShell(defn->closeCursor);
	defn->cursorColumnCount = (int (*)(dbCursor *)) buildEnvironmentShell(defn->cursorColumnCount);
	defn->cursorColumnName = (REALstring (*)(dbCursor *, int column)) buildEnvironmentShell(defn->cursorColumnName);
	defn->cursorRowCount = (int (*)(dbCursor *)) buildEnvironmentShell(defn->cursorRowCount);
	defn->cursorColumnValue = (void (*)(dbCursor *, int, Ptr *, dbFieldType *, int *)) buildEnvironmentShell(defn->cursorColumnValue);
	defn->cursorReleaseValue = (void (*)(dbCursor *)) buildEnvironmentShell(defn->cursorReleaseValue);
	defn->cursorNextRow = (Boolean (*)(dbCursor *)) buildEnvironmentShell(defn->cursorNextRow);
	defn->cursorDelete = (void (*)(dbCursor *)) buildEnvironmentShell(defn->cursorDelete);
	defn->cursorDeleteAll = (void (*)(dbCursor *)) buildEnvironmentShell(defn->cursorDeleteAll);
	#endif
	if (pRegisterDBCursor)
		pRegisterDBCursor(defn);
}

void REALRegisterClass(REALclassDefinition *defn)
{
	static void (*pRegisterClass)(REALclassDefinition *defn);
	if (!pRegisterClass)
		pRegisterClass = (void (*)(REALclassDefinition *)) CallResolver("PluginRegisterClass");
	#ifdef USECALLSHELL
	int i;
	defn->constructor = buildEnvironmentShell(defn->constructor);
	defn->destructor = buildEnvironmentShell(defn->destructor);
	for (i = 0; i < defn->propertyCount; i++)
	{
		defn->properties[i].getter = buildEnvironmentShell(defn->properties[i].getter);
		defn->properties[i].setter = buildEnvironmentShell(defn->properties[i].setter);
	}
	for (i = 0; i < defn->methodCount; i++)
	{
		defn->methods[i].function = buildEnvironmentShell(defn->methods[i].function);
		defn->methods[i].setterFunction = buildEnvironmentShell(defn->methods[i].setterFunction);
	}
	for (i = 0; i < defn->eventInstanceCount; i++)
		defn->eventInstances[i].implementation = buildEnvironmentShell(defn->eventInstances[i].implementation);
	#endif
	
	if (REALGetRBVersion() < 5.9) {
	  defn->methods = ConvertCurrentMethodsToV6( defn->methods, defn->methodCount );
	}
	
	if (pRegisterClass)
		pRegisterClass(defn);
}

const char *REALCString(REALstring str)
{
	static unsigned long (*pCString)(REALstring) = nil;
	if (!pCString)
		pCString = (unsigned long (*)(REALstring)) CallResolver("StringGetCString");
	if (pCString) return (const char *)pCString(str);
	else return (const char *)0;
}

const unsigned char *REALPString(REALstring str)
{
	static unsigned long (*pPString)(REALstring) = nil;
	if (!pPString)
		pPString = (unsigned long (*)(REALstring)) CallResolver("StringGetPString");
	if (pPString) return (const unsigned char *)pPString(str);
	else return (const unsigned char *)0;
}

REALstring REALInterpretConstantValue(REALstring value)
{
	static REALstring (*pInterpretConstantValue)(REALstring);
	if (!pInterpretConstantValue)
		pInterpretConstantValue = (REALstring (*)(REALstring)) CallResolver("PluginInterpretConstantValue");
	if (!pInterpretConstantValue)
	{
		REALLockString(value);
		return value;
	}
	return pInterpretConstantValue(value);
}

REALstring REALDefaultControlFont(void)
{
	static unsigned long (*pDefaultControlFont)(void) = nil;
	if (!pDefaultControlFont)
		pDefaultControlFont = (unsigned long (*)(void)) CallResolver("PluginDefaultControlFont");
	if (pDefaultControlFont) return (REALstring)pDefaultControlFont();
	else return (REALstring)0;
}

REALstring REALDefaultControlCaption(void)
{
	static unsigned long (*pDefaultControlCaption)(void) = nil;
	if (!pDefaultControlCaption)
		pDefaultControlCaption = (unsigned long (*)(void)) CallResolver("PluginDefaultControlCaption");
	if (pDefaultControlCaption) return (REALstring)pDefaultControlCaption();
	else return (REALstring)0;
}

unsigned long REALDefaultControlFontSize(void)
{
	static unsigned long (*pDefaultControlFontSize)(void) = nil;
	if (!pDefaultControlFontSize)
		pDefaultControlFontSize = (unsigned long (*)(void)) CallResolver("PluginDefaultControlFontSize");
	if (pDefaultControlFontSize) return pDefaultControlFontSize();
	else return (unsigned long)0;
}

REALstring REALBuildString(const char *contents, int length)
{
	static unsigned long (*pBuildString)(const char *, int) = nil;
	if (!pBuildString)
		pBuildString = (unsigned long (*)(const char *, int)) CallResolver("REALBuildString");
	if (pBuildString) return (REALstring)pBuildString(contents, length);
	else return (REALstring)0;
}

void REALLockObject(REALobject obj)
{
	static void (*pLockObject)(REALobject) = nil;
	if (!pLockObject)
		pLockObject = (void (*)(REALobject)) CallResolver("REALLockObject");
	if (pLockObject) pLockObject(obj);
}

void REALUnlockObject(REALobject obj)
{
	static void (*pUnlockObject)(REALobject) = nil;
	if (!pUnlockObject)
		pUnlockObject = (void (*)(REALobject)) CallResolver("REALUnlockObject");
	if (pUnlockObject) pUnlockObject(obj);
}

void REALLockString(REALstring str)
{
	static void (*pLockString)(REALstring) = nil;
	if (!pLockString)
		pLockString = (void (*)(REALstring)) CallResolver("REALLockString");
	if (pLockString) pLockString(str);
}

void REALUnlockString(REALstring str)
{
	static void (*pUnlockString)(REALstring) = nil;
	if (!pUnlockString)
		pUnlockString = (void (*)(REALstring)) CallResolver("REALUnlockString");
	if (pUnlockString) pUnlockString(str);
}

REALproc REALInterfaceRoutine(REALobject obj, const char *interfaceName, const char *methodName)
{
	static unsigned long (*pInterfaceRoutine)(REALobject, const char *, const char *) = nil;
	if (!pInterfaceRoutine)
		pInterfaceRoutine = (unsigned long (*)(REALobject, const char *, const char *)) CallResolver("GetInterfaceRoutine");
	if (pInterfaceRoutine) return (REALproc)pInterfaceRoutine(obj, interfaceName, methodName);
	else return (REALproc)0;
}

#if (TARGET_68K || TARGET_PPC || TARGET_CARBON) && !TARGET_COCOA
REALpicture REALBuildPictureFromPicHandle(PicHandle pic, Boolean bPassOwnership)
{
	static unsigned long (*pBuildPictureFromPicHandle)(PicHandle, Boolean) = nil;
	if (!pBuildPictureFromPicHandle)
		pBuildPictureFromPicHandle = (unsigned long (*)(PicHandle, Boolean)) CallResolver("REALBuildPictureFromPicHandle");
	if (pBuildPictureFromPicHandle) return (REALpicture)pBuildPictureFromPicHandle(pic, bPassOwnership);
	else return (REALpicture)0;
}
#endif

REALpicture REALBuildPictureFromGWorld(void *world, Boolean bPassOwnership)
{
	static unsigned long (*pBuildPictureFromGWorld)(void *, Boolean) = nil;
	if (!pBuildPictureFromGWorld)
		pBuildPictureFromGWorld = (unsigned long (*)(void *, Boolean)) CallResolver("REALBuildPictureFromGWorld");
	if (pBuildPictureFromGWorld) return (REALpicture)pBuildPictureFromGWorld(world, bPassOwnership);
	else return (REALpicture)0;
}

REALpicture REALBuildPictureFromPictureDescription(REALpictureDescription *description, Boolean bPassOwnership)
{
	static unsigned long (*pBuildPictureFromPictureDescription)(REALpictureDescription *, Boolean) = nil;
	if (!pBuildPictureFromPictureDescription)
		pBuildPictureFromPictureDescription = (unsigned long (*)(REALpictureDescription *, Boolean)) CallResolver("REALBuildPictureFromPictureDescription");
	if (pBuildPictureFromPictureDescription) return (REALpicture)pBuildPictureFromPictureDescription(description, bPassOwnership);
	else return (REALpicture)0;
}

void REALLockPictureDescriptionWithNativeType(REALpicture pic, REALpictureDescription *description)
{
	static void (*pLockPictureDescription)(REALpicture, REALpictureDescription *) = nil;
	if (!pLockPictureDescription)
		pLockPictureDescription = (void (*)(REALpicture, REALpictureDescription *)) CallResolver("lockPictureDescription");
	if (pLockPictureDescription) pLockPictureDescription(pic, description);
}

void REALUnlockPictureDescription(REALpicture pic)
{
	static void (*pUnlockPictureDescription)(REALpicture) = nil;
	if (!pUnlockPictureDescription)
		pUnlockPictureDescription = (void (*)(REALpicture)) CallResolver("unlockPictureDescription");
	if (pUnlockPictureDescription) pUnlockPictureDescription(pic);
}

void REALLockSoundDescription(REALsound sound, REALsoundDescription *description)
{
	static void (*pLockSoundDescription)(REALsound, REALsoundDescription *) = nil;
	if (!pLockSoundDescription)
		pLockSoundDescription = (void (*)(REALsound, REALsoundDescription *)) CallResolver("");
	if (pLockSoundDescription) pLockSoundDescription(sound, description);
}

void REALUnlockSoundDescription(REALsound sound)
{
	static void (*pUnlockSoundDescription)(REALsound) = nil;
	if (!pUnlockSoundDescription)
		pUnlockSoundDescription = (void (*)(REALsound)) CallResolver("unlockPictureDescription");
	if (pUnlockSoundDescription) pUnlockSoundDescription(sound);
}

void REALPictureClearCache(REALpicture pic)
{
	static void (*pPictureClearCache)(REALpicture) = nil;
	if (!pPictureClearCache)
		pPictureClearCache = (void (*)(REALpicture)) CallResolver("REALPictureClearCache");
	if (pPictureClearCache) pPictureClearCache(pic);
}

#if TARGET_WIN32
void REALDrawPicturePrimitive(HDC hDC, REALpicture pic, const Rect *rBounds, int bTransparent)
{
	static void (*pDrawPicturePrimitive)(HDC, REALpicture, const Rect *, int) = nil;
	if (!pDrawPicturePrimitive)
		pDrawPicturePrimitive = (void (*)(HDC, REALpicture, const Rect *, int)) CallResolver("drawPicturePrimitive");
	if (pDrawPicturePrimitive) pDrawPicturePrimitive(hDC, pic, rBounds, bTransparent);
}
#endif

#if (TARGET_68K || TARGET_PPC || TARGET_CARBON) && !TARGET_COCOA
void REALDrawPicturePrimitive(REALpicture pic, const Rect *rBounds, int bTransparent)
{
	static void (*pDrawPicturePrimitive)(REALpicture, const Rect *, int) = nil;
	if (!pDrawPicturePrimitive)
		pDrawPicturePrimitive = (void (*)(REALpicture, const Rect *, int)) CallResolver("drawPicturePrimitive");
	if (pDrawPicturePrimitive) pDrawPicturePrimitive(pic, rBounds, bTransparent);
}
#endif

REALdbCursor REALdbCursorFromDBCursor(dbCursor *cursor, REALdbCursorDefinition *defn)
{
	static REALdbCursor (*pDbCursorFromDBCursor)(dbCursor *, REALdbCursorDefinition *) = nil;
	if (!pDbCursorFromDBCursor)
		pDbCursorFromDBCursor = (REALdbCursor (*)(dbCursor *, REALdbCursorDefinition *)) CallResolver("REALdbCursorFromDBCursor");
	if (pDbCursorFromDBCursor) return pDbCursorFromDBCursor(cursor, defn);
	else return (REALdbCursor)0;
}

REALdbDatabase REALdbDatabaseFromDBDatabase(dbDatabase *database, REALdbEngineDefinition *defn)
{
	static REALdbDatabase (*pDbDatabaseFromDBDatabase)(dbDatabase *, REALdbEngineDefinition *) = nil;
	if (!pDbDatabaseFromDBDatabase)
		pDbDatabaseFromDBDatabase = (REALdbDatabase (*)(dbDatabase *, REALdbEngineDefinition *)) CallResolver("REALdbDatabaseFromDBDatabase");
	if (pDbDatabaseFromDBDatabase) return pDbDatabaseFromDBDatabase(database, defn);
	else return (REALdbDatabase)0;
}

void *REALGetEventInstance(REALcontrolInstance instance, REALevent *event)
{
	static void *(*pGetEventInstance)(REALcontrolInstance instance, int builtHook);
	#ifdef powerc
	if (!pGetEventInstance)
		pGetEventInstance = (void *(*)(REALcontrolInstance,int)) CallResolver("GetEventInstancePPC");
	if (pGetEventInstance) return (void *) pGetEventInstance(instance, event->forSystemUse);
	#else
	if (!pGetEventInstance)
		pGetEventInstance = (void *(*)(REALcontrolInstance,int)) CallResolver("GetEventInstance");
	if (pGetEventInstance) return (void *) pGetEventInstance(instance, event->forSystemUse);
	#endif
	return nil;
}

#if (TARGET_68K || TARGET_PPC || TARGET_CARBON) && !TARGET_COCOA
void REALRegisterEventFilter(REALEventCallback callback, long param)
{
	static void (*pRegisterEventFilter)(REALEventCallback, long param);
	#ifdef powerc
	if (!pRegisterEventFilter)
		pRegisterEventFilter = (void (*)(REALEventCallback, long)) CallResolver("PluginRegisterEventFilterPPC");
	#else
	if (!pRegisterEventFilter)
		pRegisterEventFilter = (void (*)(REALEventCallback, long)) CallResolver("PluginRegisterEventFilter");
	#endif
	if (pRegisterEventFilter) pRegisterEventFilter(callback, param);
}
#endif

void *REALGetControlData(REALcontrolInstance instance, REALcontrol *defn)
{
	return ((Ptr) instance) + defn->forSystemUse;
}

void *REALGetClassData(REALobject instance, REALclassDefinition *defn)
{
	return ((Ptr) instance) + defn->forSystemUse;
}

void REALGetControlBounds(REALcontrolInstance instance, Rect *rBounds)
{
	static void (*pGetControlBounds)(REALcontrolInstance, Rect *) = nil;
	if (!pGetControlBounds)
		pGetControlBounds = (void (*)(REALcontrolInstance, Rect *)) CallResolver("GetControlBounds");
	if (pGetControlBounds) pGetControlBounds(instance, rBounds);
}

long REALGetControlVisible(REALcontrolInstance instance)
{
	static long (*pGetControlVisible)(REALcontrolInstance) = nil;
	if (!pGetControlVisible)
		pGetControlVisible = (long (*)(REALcontrolInstance)) CallResolver("GetControlVisible");
	if (pGetControlVisible) return pGetControlVisible(instance);
	else return (long)0;
}

Boolean REALGetControlEnabled(REALcontrolInstance instance)
{
	static Boolean (*pGetControlEnabled)(REALcontrolInstance) = nil;
	if (!pGetControlEnabled)
		pGetControlEnabled = (Boolean (*)(REALcontrolInstance)) CallResolver("REALGetControlEnabled");
	if (pGetControlEnabled) return pGetControlEnabled(instance);
	else return (Boolean)0;
}

void REALSetControlVisible(REALcontrolInstance instance, unsigned long visible)
{
	static void (*pSetControlVisible)(REALcontrolInstance, unsigned long) = nil;
	if (!pSetControlVisible)
		pSetControlVisible = (void (*)(REALcontrolInstance, unsigned long)) CallResolver("SetControlVisible");
	if (pSetControlVisible) pSetControlVisible(instance, visible);
}

REALgraphics REALGetControlGraphics(REALcontrolInstance instance)
{
	static unsigned long (*pGetControlGraphics)(REALcontrolInstance) = nil;
	if (!pGetControlGraphics)
		pGetControlGraphics = (unsigned long (*)(REALcontrolInstance)) CallResolver("REALGetControlGraphics");
	if (pGetControlGraphics) return (REALgraphics)pGetControlGraphics(instance);
	else return (REALgraphics)0;
}

#if TARGET_WIN32
int REALGetWin32Charset(void)
{
	static int (*pGetWin32Charset)(void) = nil;
	if (!pGetWin32Charset)
		pGetWin32Charset = (int (*)(void)) CallResolver("REALGetWin32Charset");
	if (pGetWin32Charset) return pGetWin32Charset();
	else return (int)0;
}
#endif

#if TARGET_WIN32 || UNIX_ANSI
REALfolderItem REALFolderItemFromPath(const char *path)
{
	static unsigned long (*pFolderItemFromPath)(const char *) = nil;
	if (!pFolderItemFromPath)
		pFolderItemFromPath = (unsigned long (*)(const char *)) CallResolver("FolderItemFromPath");
	if (pFolderItemFromPath) return (REALfolderItem)pFolderItemFromPath(path);
	else return (REALfolderItem)0;
}
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON
REALfolderItem REALFolderItemFromFSSpec(const FSSpec *spec)
{
	static unsigned long (*pFolderItemFromFSSpec)(const FSSpec *) = nil;
	if (!pFolderItemFromFSSpec)
		pFolderItemFromFSSpec = (unsigned long (*)(const FSSpec *)) CallResolver("FolderItemFromFSSpec");
	if (pFolderItemFromFSSpec) return (REALfolderItem)pFolderItemFromFSSpec(spec);
	else return (REALfolderItem)0;
}
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON
Boolean REALFSSpecFromFolderItem(FSSpec *spec, REALfolderItem item)
{
	static Boolean (*pFSSpecFromFolderItem)(FSSpec *, REALfolderItem) = nil;
	if (!pFSSpecFromFolderItem)
		pFSSpecFromFolderItem = (Boolean (*)(FSSpec *, REALfolderItem)) CallResolver("REALFSSpecFromFolderItem");
	if (pFSSpecFromFolderItem) return pFSSpecFromFolderItem(spec, item);
	else return (Boolean)0;
}
#endif

REALstring REALpathFromFolderItem(REALfolderItem item)
{
	static unsigned long (*pPathFromFolderItem)(REALfolderItem) = nil;
	if (!pPathFromFolderItem)
		pPathFromFolderItem = (unsigned long (*)(REALfolderItem)) CallResolver("REALpathFromFolderItem");
	if (pPathFromFolderItem) return (REALstring)pPathFromFolderItem(item);
	else return (REALstring)0;
}

#if TARGET_WIN32
HDC REALGraphicsDC(REALgraphics context)
{
	static unsigned long (*pGraphicsDC)(REALgraphics) = nil;
	if (!pGraphicsDC)
		pGraphicsDC = (unsigned long (*)(REALgraphics)) CallResolver("REALGraphicsDC");
	if (pGraphicsDC) return (HDC)pGraphicsDC(context);
	else return (HDC)0;
}
#endif

#if COCOA
CGContextRef REALGraphicsCGContext(REALgraphics context)
{
	static unsigned long (*pGraphicsCGContext)(REALgraphics) = nil;
	if (!pGraphicsCGContext)
		pGraphicsCGContext = (unsigned long (*)(REALgraphics)) CallResolver("REALGraphicsCGContext");
	if (pGraphicsCGContext) return (CGContextRef)pGraphicsCGContext(context);
	else return (CGContextRef)0;
}
#endif

#if TARGET_WIN32
HWND REALGetControlHWND(REALcontrolInstance control)
{
	static HWND (*pGetControlHWND)(REALcontrolInstance) = nil;
	if (!pGetControlHWND)
		pGetControlHWND = (HWND (*)(REALcontrolInstance)) CallResolver("GetControlHWND");
	if (pGetControlHWND) return pGetControlHWND(control);
	else return (HWND)0;
}
#endif

#if (TARGET_68K || TARGET_PPC || TARGET_CARBON) && !TARGET_COCOA
void REALSelectGraphics(REALgraphics context)
{
	static void (*pSelectGraphics)(REALgraphics) = nil;
	if (!pSelectGraphics)
		pSelectGraphics = (void (*)(REALgraphics)) CallResolver("SelectGraphics");
	if (pSelectGraphics) pSelectGraphics(context);
}
#endif

#if (TARGET_68K || TARGET_PPC || TARGET_CARBON) && !TARGET_COCOA
void REALGraphicsDrawOffscreenMacControl(REALgraphics context, ControlHandle mh)
{
	static void (*pGraphicsDrawOffscreenMacControl)(REALgraphics, ControlHandle) = nil;
	if (!pGraphicsDrawOffscreenMacControl)
		pGraphicsDrawOffscreenMacControl = (void (*)(REALgraphics, ControlHandle)) CallResolver("DrawOffscreenMacControl");
	if (pGraphicsDrawOffscreenMacControl) pGraphicsDrawOffscreenMacControl(context, mh);
}
#endif

void REALInvalidateControl(REALcontrolInstance instance)
{
	static void (*pInvalidateControl)(REALcontrolInstance) = nil;
	if (!pInvalidateControl)
		pInvalidateControl = (void (*)(REALcontrolInstance)) CallResolver("REALInvalidateControl");
	if (pInvalidateControl) pInvalidateControl(instance);
}

void REALInvalidateControlRect(REALcontrolInstance instance, int left, int top, int right, int bottom)
{
	static void (*pInvalidateControlRect)(REALcontrolInstance, int, int, int, int) = nil;
	if (!pInvalidateControlRect)
		pInvalidateControlRect = (void (*)(REALcontrolInstance, int, int, int, int)) CallResolver("REALInvalidateControlRect");
	if (pInvalidateControlRect) pInvalidateControlRect(instance, left, top, right, bottom);
}

#if TARGET_WIN32
void REALSetSpecialBackground(REALcontrolInstance instance, COLORREF *pcolor)
{
	static void (*pSetSpecialBackground)(REALcontrolInstance, COLORREF *) = nil;
	if (!pSetSpecialBackground)
		pSetSpecialBackground = (void (*)(REALcontrolInstance, COLORREF *)) CallResolver("REALSetSpecialBackground");
	if (pSetSpecialBackground) pSetSpecialBackground(instance, pcolor);
}
#endif

#if (TARGET_68K || TARGET_PPC || TARGET_CARBON) && !TARGET_COCOA
void REALSetSpecialBackground(REALcontrolInstance instance)
{
	static void (*pSetSpecialBackground)(REALcontrolInstance) = nil;
	if (!pSetSpecialBackground)
		pSetSpecialBackground = (void (*)(REALcontrolInstance)) CallResolver("REALSetSpecialBackground");
	if (pSetSpecialBackground) pSetSpecialBackground(instance);
}
#endif

REALwindow REALGetControlWindow(REALcontrolInstance instance)
{
	static REALwindow (*pGetControlWindow)(REALcontrolInstance) = nil;
	if (!pGetControlWindow)
		pGetControlWindow = (REALwindow (*)(REALcontrolInstance)) CallResolver("getControlWindow");
	if (pGetControlWindow) return pGetControlWindow(instance);
	else return (REALwindow)0;
}

#if (TARGET_68K || TARGET_PPC || TARGET_CARBON) && !TARGET_COCOA
REALsound REALBuildSoundFromHandle(Handle sound, Boolean bPassOwnership)
{
	static REALsound (*pBuildSoundFromHandle)(Handle, Boolean) = nil;
	if (!pBuildSoundFromHandle)
		pBuildSoundFromHandle = (REALsound (*)(Handle, Boolean)) CallResolver("REALBuildSoundFromHandle");
	if (pBuildSoundFromHandle) return pBuildSoundFromHandle(sound, bPassOwnership);
	else return (REALsound)0;
}
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON
REALappleEvent REALBuildAppleEvent(const AppleEvent *event, Boolean bPassOwnership)
{
	static unsigned long (*pBuildAppleEvent)(const AppleEvent *, Boolean) = nil;
	if (!pBuildAppleEvent)
		pBuildAppleEvent = (unsigned long (*)(const AppleEvent *, Boolean)) CallResolver("REALBuildAppleEvent");
	if (pBuildAppleEvent) return (REALappleEvent)pBuildAppleEvent(event, bPassOwnership);
	else return (REALappleEvent)0;
}
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON
REALappleEvent REALBuildAEDescList(const AppleEvent *event, Boolean bPassOwnership)
{
	static unsigned long (*pBuildAEDescList)(const AppleEvent *, Boolean) = nil;
	if (!pBuildAEDescList)
		pBuildAEDescList = (unsigned long (*)(const AppleEvent *, Boolean)) CallResolver("REALBuildAEDescList");
	if (pBuildAEDescList) return (REALappleEvent)pBuildAEDescList(event, bPassOwnership);
	else return (REALappleEvent)0;
}
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON
REALappleEvent REALBuildAEObjSpecifier(const AppleEvent *event, Boolean bPassOwnership)
{
	static unsigned long (*pBuildAEObjSpecifier)(const AppleEvent *, Boolean) = nil;
	if (!pBuildAEObjSpecifier)
		pBuildAEObjSpecifier = (unsigned long (*)(const AppleEvent *, Boolean)) CallResolver("REALBuildAEObjSpecifier");
	if (pBuildAEObjSpecifier) return (REALappleEvent)pBuildAEObjSpecifier(event, bPassOwnership);
	else return (REALappleEvent)0;
}
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON
AppleEvent *REALAccessAppleEvent(REALappleEvent event)
{
	static unsigned long (*pAccessAppleEvent)(REALappleEvent) = nil;
	if (!pAccessAppleEvent)
		pAccessAppleEvent = (unsigned long (*)(REALappleEvent)) CallResolver("REALAccessAppleEvent");
	if (pAccessAppleEvent) return (AppleEvent *)pAccessAppleEvent(event);
	else return (AppleEvent *)0;
}
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON
AppleEvent *REALAccessAppleEventReply(REALappleEvent event)
{
	static unsigned long (*pAccessAppleEventReply)(REALappleEvent) = nil;
	if (!pAccessAppleEventReply)
		pAccessAppleEventReply = (unsigned long (*)(REALappleEvent)) CallResolver("REALAccessAppleEventReply");
	if (pAccessAppleEventReply) return (AppleEvent *)pAccessAppleEventReply(event);
	else return (AppleEvent *)0;
}
#endif

#if TARGET_COCOA
NSWindow *REALGetWindowHandle(REALwindow window)
{
	static unsigned long (*pGetWindowHandle)(REALwindow) = nil;
	if (!pGetWindowHandle)
		pGetWindowHandle = (unsigned long (*)(REALwindow)) CallResolver("REALGetWindowHandle");
	if (pGetWindowHandle) return (NSWindow *)pGetWindowHandle(window);
	else return (NSWindow *)0;
}
#endif

#if (TARGET_68K || TARGET_PPC || TARGET_CARBON) && !TARGET_COCOA
WindowPtr REALGetWindowHandle(REALwindow window)
{
	static unsigned long (*pGetWindowHandle)(REALwindow) = nil;
	if (!pGetWindowHandle)
		pGetWindowHandle = (unsigned long (*)(REALwindow)) CallResolver("REALGetWindowHandle");
	if (pGetWindowHandle) return (WindowPtr)pGetWindowHandle(window);
	else return (WindowPtr)0;
}
#endif

#if TARGET_COCOA
NSView *REALGetControlHandle(REALcontrolInstance control)
{
	static unsigned long (*pGetControlHandle)(REALcontrolInstance) = nil;
	if (!pGetControlHandle)
		pGetControlHandle = (unsigned long (*)(REALcontrolInstance)) CallResolver("REALGetControlHandle");
	if (pGetControlHandle) return (NSView *)pGetControlHandle(control);
	else return (NSView *)0;
}
#endif

#if (TARGET_68K || TARGET_PPC || TARGET_CARBON) && !TARGET_COCOA
ControlHandle REALGetControlHandle(REALcontrolInstance control)
{
	static unsigned long (*pGetControlHandle)(REALcontrolInstance) = nil;
	if (!pGetControlHandle)
		pGetControlHandle = (unsigned long (*)(REALcontrolInstance)) CallResolver("REALGetControlHandle");
	if (pGetControlHandle) return (ControlHandle)pGetControlHandle(control);
	else return (ControlHandle)0;
}
#endif

#if (TARGET_PPC || TARGET_CARBON) && !TARGET_COCOA
MenuHandle REALGetPopupMenuHandle(REALpopupMenu popup)
{
	static unsigned long (*pGetPopupMenuHandle)(REALpopupMenu) = nil;
	if (!pGetPopupMenuHandle)
		pGetPopupMenuHandle = (unsigned long (*)(REALpopupMenu)) CallResolver("REALGetPopupMenuHandle");
	if (pGetPopupMenuHandle) return (MenuHandle)pGetPopupMenuHandle(popup);
	else return (MenuHandle)0;
}
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || TARGET_COCOA
QT_NAMESPACE MovieController REALgetMoviePlayerController(REALmoviePlayer instance)
{
	static unsigned long (*pGetMoviePlayerController)(REALmoviePlayer) = nil;
	if (!pGetMoviePlayerController)
		pGetMoviePlayerController = (unsigned long (*)(REALmoviePlayer)) CallResolver("getMoviePlayerController");
	if (pGetMoviePlayerController) return (QT_NAMESPACE MovieController)pGetMoviePlayerController(instance);
	else return (QT_NAMESPACE MovieController)0;
}
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || TARGET_COCOA
QT_NAMESPACE Movie REALgetMovieMovie(REALmovie instance)
{
	static unsigned long (*pGetMovieMovie)(REALmovie) = nil;
	if (!pGetMovieMovie)
		pGetMovieMovie = (unsigned long (*)(REALmovie)) CallResolver("getMovieMovie");
	if (pGetMovieMovie) return (QT_NAMESPACE Movie)pGetMovieMovie(instance);
	else return (QT_NAMESPACE Movie)0;
}
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON || TARGET_COCOA
REALmovie REALbuildMovie(QT_NAMESPACE Movie movie, int resRefNum, int bNew)
{
	static unsigned long (*pBuildMovie)(QT_NAMESPACE Movie, int, int) = nil;
	if (!pBuildMovie)
		pBuildMovie = (unsigned long (*)(QT_NAMESPACE Movie, int, int)) CallResolver("buildMovie");
	if (pBuildMovie) return (REALmovie)pBuildMovie(movie, resRefNum, bNew);
	else return (REALmovie)0;
}
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON || TARGET_COCOA
void REALmarkMovieDirty(REALmovie movie)
{
	static void (*pMarkMovieDirty)(REALmovie) = nil;
	if (!pMarkMovieDirty)
		pMarkMovieDirty = (void (*)(REALmovie)) CallResolver("markMovieDirty");
	if (pMarkMovieDirty) pMarkMovieDirty(movie);
}
#endif

#if TARGET_68K || TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || TARGET_COCOA
int REALenterMovies(void)
{
	static int (*pEnterMovies)(void) = nil;
	if (!pEnterMovies)
		pEnterMovies = (int (*)(void)) CallResolver("REALenterMovies");
	if (pEnterMovies) return pEnterMovies();
	else return (int)0;
}
#endif

REALobject REALnewInstance(const char *className)
{
	static unsigned long (*pNewInstance)(const char *) = nil;
	if (!pNewInstance)
		pNewInstance = (unsigned long (*)(const char *)) CallResolver("PluginNewInstance");
	if (pNewInstance) return (REALobject)pNewInstance(className);
	else return (REALobject)0;
}

void REALMarkSocketUsage(void)
{
	static void (*pMarkSocketUsage)(void) = nil;
	if (!pMarkSocketUsage)
		pMarkSocketUsage = (void (*)(void)) CallResolver("PluginMarkSocketUsage");
	if (pMarkSocketUsage) pMarkSocketUsage();
}

void REALSocketConnect(REALsocket socket, REALstring address, int port)
{
	static void (*pSocketConnect)(REALsocket, REALstring, int) = nil;
	if (!pSocketConnect)
		pSocketConnect = (void (*)(REALsocket, REALstring, int)) CallResolver("socketDirectConnect");
	if (pSocketConnect) pSocketConnect(socket, address, port);
}

void REALSocketClose(REALsocket socket)
{
	static void (*pSocketClose)(REALsocket) = nil;
	if (!pSocketClose)
		pSocketClose = (void (*)(REALsocket)) CallResolver("socketClose");
	if (pSocketClose) pSocketClose(socket);
}

REALstring REALSocketReadAll(REALsocket socket)
{
	static unsigned long (*pSocketReadAll)(REALsocket) = nil;
	if (!pSocketReadAll)
		pSocketReadAll = (unsigned long (*)(REALsocket)) CallResolver("pluginSocketReadAll");
	if (pSocketReadAll) return (REALstring)pSocketReadAll(socket);
	else return (REALstring)0;
}

REALstring REALSocketRead(REALsocket socket, int count)
{
	static unsigned long (*pSocketRead)(REALsocket, int) = nil;
	if (!pSocketRead)
		pSocketRead = (unsigned long (*)(REALsocket, int)) CallResolver("pluginSocketRead");
	if (pSocketRead) return (REALstring)pSocketRead(socket, count);
	else return (REALstring)0;
}

void REALSocketWrite(REALsocket socket, REALstring data)
{
	static void (*pSocketWrite)(REALsocket, REALstring) = nil;
	if (!pSocketWrite)
		pSocketWrite = (void (*)(REALsocket, REALstring)) CallResolver("SocketWrite");
	if (pSocketWrite) pSocketWrite(socket, data);
}

int REALSocketLastErrorCode(REALsocket socket, int unused)
{
	static int (*pSocketLastErrorCode)(REALsocket, int) = nil;
	if (!pSocketLastErrorCode)
		pSocketLastErrorCode = (int (*)(REALsocket, int)) CallResolver("socketLastErrorCode");
	if (pSocketLastErrorCode) return pSocketLastErrorCode(socket, unused);
	else return (int)0;
}

REALstring REALSocketLookahead(REALsocket socket, int unused)
{
	static unsigned long (*pSocketLookahead)(REALsocket, int) = nil;
	if (!pSocketLookahead)
		pSocketLookahead = (unsigned long (*)(REALsocket, int)) CallResolver("pluginSocketLookahead");
	if (pSocketLookahead) return (REALstring)pSocketLookahead(socket, unused);
	else return (REALstring)0;
}

REALstring REALSocketLocalAddressGetter(REALsocket socket)
{
	static REALstring (*pSocketLocalAddressGetter)(REALsocket) = nil;
	if (!pSocketLocalAddressGetter)
		pSocketLocalAddressGetter = (REALstring (*)(REALsocket)) CallResolver("socketLocalAddressGetter");
	if (pSocketLocalAddressGetter) return pSocketLocalAddressGetter(socket);
	else return (REALstring)0;
}

void REALSocketPoll(REALsocket socket)
{
	static void (*pSocketPoll)(REALsocket) = nil;
	if (!pSocketPoll)
		pSocketPoll = (void (*)(REALsocket)) CallResolver("socketPoll");
	if (pSocketPoll) pSocketPoll(socket);
}

int REALSocketGetEvents(REALsocket socket, int unused)
{
	static int (*pSocketGetEvents)(REALsocket, int) = nil;
	if (!pSocketGetEvents)
		pSocketGetEvents = (int (*)(REALsocket, int)) CallResolver("socketGetEvents");
	if (pSocketGetEvents) return pSocketGetEvents(socket, unused);
	else return (int)0;
}

void REALRegisterDataSourceInterface(const char *szMenuName, REALDataSourceInterfaceProc proc)
{
	static void (*pRegisterDataSourceInterface)(const char *, REALDataSourceInterfaceProc) = nil;
	if (!pRegisterDataSourceInterface)
		pRegisterDataSourceInterface = (void (*)(const char *, REALDataSourceInterfaceProc)) CallResolver("RegisterDataSourceInterface");
	if (pRegisterDataSourceInterface)
	#ifdef USECALLSHELL
		pRegisterDataSourceInterface(szMenuName, buildEnvironmentShell(proc));
	#else
		pRegisterDataSourceInterface(szMenuName, proc);
	#endif
}

void REALRegisterDataSource(const char *szDatasourceName, REALDataSourceProc proc)
{
	static void (*pRegisterDataSource)(const char *, REALDataSourceProc);
	if (!pRegisterDataSource)
		pRegisterDataSource = (void (*)(const char *, REALDataSourceProc)) CallResolver("RegisterDataSource");
	if (pRegisterDataSource) {
	#ifdef USECALLSHELL
	pRegisterDataSource(szDatasourceName, (REALDataSourceProc) buildEnvironmentShell(proc));
	#else
	pRegisterDataSource(szDatasourceName, proc);
	#endif
	}
}

void REALDesignAddDataSource(const char *baseName, const char *szDataSourceName, Ptr data, int dataLen)
{
	static void (*pDesignAddDataSource)(const char *, const char *, Ptr, int) = nil;
	if (!pDesignAddDataSource)
		pDesignAddDataSource = (void (*)(const char *, const char *, Ptr, int)) CallResolver("DesignAddDataSource");
	if (pDesignAddDataSource) pDesignAddDataSource(baseName, szDataSourceName, data, dataLen);
}

void REALMessageBox(REALstring text)
{
	static void (*pMessageBox)(REALstring) = nil;
	if (!pMessageBox)
		pMessageBox = (void (*)(REALstring)) CallResolver("RuntimeMsgBox");
	if (pMessageBox) pMessageBox(text);
}

#if TARGET_WIN32
REALpicture REALBuildPictureFromDIB(HANDLE hDIB, Boolean bPassOwnership)
{
	static unsigned long (*pBuildPictureFromDIB)(HANDLE, Boolean) = nil;
	if (!pBuildPictureFromDIB)
		pBuildPictureFromDIB = (unsigned long (*)(HANDLE, Boolean)) CallResolver("REALBuildPictureFromDIB");
	if (pBuildPictureFromDIB) return (REALpicture)pBuildPictureFromDIB(hDIB, bPassOwnership);
	else return (REALpicture)0;
}
#endif

void REALSetControlEnabled(REALcontrolInstance instance, long unused, Boolean enable)
{
	static void (*pSetControlEnabled)(REALcontrolInstance, long, Boolean) = nil;
	if (!pSetControlEnabled)
		pSetControlEnabled = (void (*)(REALcontrolInstance, long, Boolean)) CallResolver("controlEnabledSetter");
	if (pSetControlEnabled) pSetControlEnabled(instance, unused, enable);
}

long REALGetControlPosition(REALcontrolInstance instance, long which)
{
	static unsigned long (*pGetControlPosition)(REALcontrolInstance, long) = nil;
	if (!pGetControlPosition)
		pGetControlPosition = (unsigned long (*)(REALcontrolInstance, long)) CallResolver("ctlPosGetter");
	if (pGetControlPosition) return (long)pGetControlPosition(instance, which);
	else return (long)0;
}

void REALSetControlPosition(REALcontrolInstance instance, long which, long value)
{
	static void (*pSetControlPosition)(REALcontrolInstance, long, long) = nil;
	if (!pSetControlPosition)
		pSetControlPosition = (void (*)(REALcontrolInstance, long, long)) CallResolver("ctlPosSetter");
	if (pSetControlPosition) pSetControlPosition(instance, which, value);
}

#if (TARGET_68K || TARGET_PPC || TARGET_CARBON) && !TARGET_COCOA
void REALRefreshWindow(unsigned long macWindowPtr)
{
	static void (*pRefreshWindow)(unsigned long) = nil;
	if (!pRefreshWindow)
		pRefreshWindow = (void (*)(unsigned long)) CallResolver("REALRefreshWindow");
	if (pRefreshWindow) pRefreshWindow(macWindowPtr);
}
#endif

REALgraphics REALGetPictureGraphics(REALpicture picture)
{
	static unsigned long (*pGetPictureGraphics)(REALpicture) = nil;
	if (!pGetPictureGraphics)
		pGetPictureGraphics = (unsigned long (*)(REALpicture)) CallResolver("pluginPictureGraphicsGetter");
	if (pGetPictureGraphics) return (REALgraphics)pGetPictureGraphics(picture);
	else return (REALgraphics)0;
}

REALpicture REALNewPicture(long width, long height, long depth)
{
	static unsigned long (*pNewPicture)(long, long, long) = nil;
	if (!pNewPicture)
		pNewPicture = (unsigned long (*)(long, long, long)) CallResolver("newPicture");
	if (pNewPicture) return (REALpicture)pNewPicture(width, height, depth);
	else return (REALpicture)0;
}

REALmemoryBlock REALNewMemoryBlock(int bytes)
{
	static unsigned long (*pNewMemoryBlock)(int) = nil;
	if (!pNewMemoryBlock)
		pNewMemoryBlock = (unsigned long (*)(int)) CallResolver("newMemoryBlock");
	if (pNewMemoryBlock) return (REALmemoryBlock)pNewMemoryBlock(bytes);
	else return (REALmemoryBlock)0;
}

void*REALMemoryBlockGetPtr(REALmemoryBlock memBlock)
{
	static unsigned long (*pMemoryBlockGetPtr)(REALmemoryBlock) = nil;
	if (!pMemoryBlockGetPtr)
		pMemoryBlockGetPtr = (unsigned long (*)(REALmemoryBlock)) CallResolver("memoryBlockGetPtr");
	if (pMemoryBlockGetPtr) return (void*)pMemoryBlockGetPtr(memBlock);
	else return (void*)0;
}

int REALMemoryBlockGetSize(REALmemoryBlock memBlock)
{
	static unsigned long (*pMemoryBlockGetSize)(REALmemoryBlock) = nil;
	if (!pMemoryBlockGetSize)
		pMemoryBlockGetSize = (unsigned long (*)(REALmemoryBlock)) CallResolver("memoryBlockGetSize");
	if (pMemoryBlockGetSize) return (int)pMemoryBlockGetSize(memBlock);
	else return (int)0;
}

REALmemoryBlock REALPtrToMemoryBlock(void*data)
{
	static unsigned long (*pPtrToMemoryBlock)(void*) = nil;
	if (!pPtrToMemoryBlock)
		pPtrToMemoryBlock = (unsigned long (*)(void*)) CallResolver("PtrToMemoryBlock");
	if (pPtrToMemoryBlock) return (REALmemoryBlock)pPtrToMemoryBlock(data);
	else return (REALmemoryBlock)0;
}

#if TARGET_WIN32 || X_WINDOW
void REALSetAccelerator(REALcontrolInstance instance, REALstring key)
{
	static void (*pSetAccelerator)(REALcontrolInstance, REALstring) = nil;
	if (!pSetAccelerator)
		pSetAccelerator = (void (*)(REALcontrolInstance, REALstring)) CallResolver("REALSetAccelerator");
	if (pSetAccelerator) pSetAccelerator(instance, key);
}
#endif

double REALGetRBVersion(void)
{
	static double (*pGetRBVersion)(void) = nil;
	if (!pGetRBVersion)
		pGetRBVersion = (double (*)(void)) CallResolver("REALGetRBVersion");
	if (pGetRBVersion) return pGetRBVersion();
	else return (double)0;
}

void REALRaiseException(REALobject exception)
{
	static void (*pRaiseException)(REALobject) = nil;
	if (!pRaiseException)
		pRaiseException = (void (*)(REALobject)) CallResolver("RuntimeRaiseException");
	if (pRaiseException) pRaiseException(exception);
}

int REALGetArrayUBound(void*array)
{
	static int (*pGetArrayUBound)(void*) = nil;
	if (!pGetArrayUBound)
		pGetArrayUBound = (int (*)(void*)) CallResolver("RuntimeUBound");
	if (pGetArrayUBound) return pGetArrayUBound(array);
	else return (int)0;
}

int REALGetArrayInt(REALintArray array, int index)
{
	static int (*pGetArrayInt)(REALintArray, int) = nil;
	if (!pGetArrayInt)
		pGetArrayInt = (int (*)(REALintArray, int)) CallResolver("RuntimeDirectReadIntArray");
	if (pGetArrayInt) return pGetArrayInt(array, index);
	else return (int)0;
}

REALstring REALGetArrayString(REALstringArray array, int index)
{
	static REALstring (*pGetArrayString)(REALstringArray, int) = nil;
	if (!pGetArrayString)
		pGetArrayString = (REALstring (*)(REALstringArray, int)) CallResolver("RuntimeDirectReadStringArray");
	if (pGetArrayString) return pGetArrayString(array, index);
	else return (REALstring)0;
}

REALobject REALGetArrayObject(REALobjectArray array, int index)
{
	static REALobject (*pGetArrayObject)(REALobjectArray, int) = nil;
	if (!pGetArrayObject)
		pGetArrayObject = (REALobject (*)(REALobjectArray, int)) CallResolver("RuntimeDirectReadObjectArray");
	if (pGetArrayObject) return pGetArrayObject(array, index);
	else return (REALobject)0;
}

void REALGetArrayStructure( REALstructureArray array, int index, void *structure )
{
	static void(*pGetStructureObject)(REALstructureArray, int, void *) = nil;
	if (!pGetStructureObject)
		pGetStructureObject = (void (*)(REALstructureArray, int, void *)) CallResolver("RuntimeDirectReadStructureArray");
	if (pGetStructureObject) pGetStructureObject(array, index, structure);
}

long REALGetTabPanelVisible(REALcontrolInstance instance)
{
	static long (*pGetTabPanelVisible)(REALcontrolInstance) = nil;
	if (!pGetTabPanelVisible)
		pGetTabPanelVisible = (long (*)(REALcontrolInstance)) CallResolver("GetTabPanelVisible");
	if (pGetTabPanelVisible) return pGetTabPanelVisible(instance);
	else return (long)0;
}

#if TARGET_WIN32
HWND REALGetControlHandle(REALcontrolInstance control)
{
	static unsigned long (*pGetControlHandle)(REALcontrolInstance) = nil;
	if (!pGetControlHandle)
		pGetControlHandle = (unsigned long (*)(REALcontrolInstance)) CallResolver("REALGetControlHandle");
	if (pGetControlHandle) return (HWND)pGetControlHandle(control);
	else return (HWND)0;
}
#endif

#if TARGET_WIN32
HWND REALGetWindowHandle(REALwindow window)
{
	static unsigned long (*pGetWindowHandle)(REALwindow) = nil;
	if (!pGetWindowHandle)
		pGetWindowHandle = (unsigned long (*)(REALwindow)) CallResolver("REALGetWindowHandle");
	if (pGetWindowHandle) return (HWND)pGetWindowHandle(window);
	else return (HWND)0;
}
#endif

Boolean REALGetControlFocus(REALcontrolInstance instance)
{
	static unsigned long (*pGetControlFocus)(REALcontrolInstance) = nil;
	if (!pGetControlFocus)
		pGetControlFocus = (unsigned long (*)(REALcontrolInstance)) CallResolver("REALGetControlFocus");
	if (pGetControlFocus) return (Boolean)pGetControlFocus(instance);
	else return (Boolean)0;
}

void REALSetControlFocus(REALcontrolInstance instance, Boolean focus)
{
	static void (*pSetControlFocus)(REALcontrolInstance, Boolean) = nil;
	if (!pSetControlFocus)
		pSetControlFocus = (void (*)(REALcontrolInstance, Boolean)) CallResolver("REALSetControlFocus");
	if (pSetControlFocus) pSetControlFocus(instance, focus);
}

void REALYieldToRB(void)
{
	static void (*pYieldToRB)(void) = nil;
	if (!pYieldToRB)
		pYieldToRB = (void (*)(void)) CallResolver("REALYieldToRB");
	if (pYieldToRB) pYieldToRB();
}

REALclassRef REALGetClassRef(const char *className)
{
	static REALclassRef (*pGetClassRef)(const char *) = nil;
	if (!pGetClassRef)
		pGetClassRef = (REALclassRef (*)(const char *)) CallResolver("pluginObjectType");
	if (pGetClassRef) return pGetClassRef(className);
	else return (REALclassRef)0;
}

REALobject REALnewInstanceWithClass(REALclassRef classRef)
{
	static unsigned long (*pNewInstance)(REALclassRef) = nil;
	if (!pNewInstance)
		pNewInstance = (unsigned long (*)(REALclassRef)) CallResolver("CreateInstance");
	if (pNewInstance and classRef) return (REALobject)pNewInstance(classRef);
	else return (REALobject)0;
}

void REALRegisterInterface(REALinterfaceDefinition *defn)
{
	static void (*pRegisterInterface)(REALinterfaceDefinition *defn);
	if (!pRegisterInterface)
		pRegisterInterface = (void (*)(REALinterfaceDefinition *)) CallResolver("PluginRegisterInterface");
	#ifdef USECALLSHELL
	for (int i = 0; i < defn->methodCount; i++)
	{
		defn->methods[i].function = buildEnvironmentShell(defn->methods[i].function);
		defn->methods[i].setterFunction = buildEnvironmentShell(defn->methods[i].setterFunction);
	}
	#endif
	
	if (REALGetRBVersion() < 5.9) {
	  defn->methods = ConvertCurrentMethodsToV6( defn->methods, defn->methodCount );
	}
	
	if (pRegisterInterface)
		pRegisterInterface(defn);
}

REALcontrolInstance REALGetControlParent(REALcontrolInstance instance)
{
	static REALcontrolInstance (*pGetControlParent)(REALcontrolInstance) = nil;
	if (!pGetControlParent)
		pGetControlParent = (REALcontrolInstance (*)(REALcontrolInstance)) CallResolver("REALGetControlParent");
	if (pGetControlParent) return pGetControlParent(instance);
	else return (REALcontrolInstance)0;
}

REALstring REALGetDBHost(REALdbDatabase db)
{
	static REALstring (*pGetDBHost)(REALdbDatabase) = nil;
	if (!pGetDBHost)
		pGetDBHost = (REALstring (*)(REALdbDatabase)) CallResolver("REALGetDBHost");
	if (pGetDBHost) return pGetDBHost(db);
	else return (REALstring)0;
}

REALstring REALGetDBDatabaseName(REALdbDatabase db)
{
	static REALstring (*pGetDBDatabaseName)(REALdbDatabase) = nil;
	if (!pGetDBDatabaseName)
		pGetDBDatabaseName = (REALstring (*)(REALdbDatabase)) CallResolver("REALGetDBDatabaseName");
	if (pGetDBDatabaseName) return pGetDBDatabaseName(db);
	else return (REALstring)0;
}

REALstring REALGetDBPassword(REALdbDatabase db)
{
	static REALstring (*pGetDBPassword)(REALdbDatabase) = nil;
	if (!pGetDBPassword)
		pGetDBPassword = (REALstring (*)(REALdbDatabase)) CallResolver("REALGetDBPassword");
	if (pGetDBPassword) return pGetDBPassword(db);
	else return (REALstring)0;
}

REALstring REALGetDBUserName(REALdbDatabase db)
{
	static REALstring (*pGetDBUserName)(REALdbDatabase) = nil;
	if (!pGetDBUserName)
		pGetDBUserName = (REALstring (*)(REALdbDatabase)) CallResolver("REALGetDBUserName");
	if (pGetDBUserName) return pGetDBUserName(db);
	else return (REALstring)0;
}

dbDatabase *REALGetDBFromREALdbDatabase(REALdbDatabase db)
{
	static dbDatabase *(*pGetDBFromREALdbDatabase)(REALdbDatabase) = nil;
	if (!pGetDBFromREALdbDatabase)
		pGetDBFromREALdbDatabase = (dbDatabase *(*)(REALdbDatabase)) CallResolver("REALGetDBFromREALdbDatabase");
	if (pGetDBFromREALdbDatabase) return pGetDBFromREALdbDatabase(db);
	else return (dbDatabase *)0;
}

void REALConstructDBDatabase(REALdbDatabase db, dbDatabase *mydb, REALdbEngineDefinition *engine)
{
	static void (*pConstructDBDatabase)(REALdbDatabase, dbDatabase *, REALdbEngineDefinition *) = nil;
	if (!pConstructDBDatabase)
		pConstructDBDatabase = (void (*)(REALdbDatabase, dbDatabase *, REALdbEngineDefinition *)) CallResolver("REALConstructDBDatabase");
	if (pConstructDBDatabase) pConstructDBDatabase(db, mydb, engine);
}

#if TARGET_68K || TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || TARGET_COCOA
void REALSetMovieMovie(REALmovie obj, Movie movie)
{
	static void (*pSetMovieMovie)(REALmovie, Movie) = nil;
	if (!pSetMovieMovie)
		pSetMovieMovie = (void (*)(REALmovie, Movie)) CallResolver("REALSetMovieMovie");
	if (pSetMovieMovie) pSetMovieMovie(obj, movie);
}
#endif

unsigned long REALGetStringEncoding(REALstring str)
{
	static unsigned long (*pGetStringEncoding)(REALstring) = nil;
	if (!pGetStringEncoding)
		pGetStringEncoding = (unsigned long (*)(REALstring)) CallResolver("REALGetStringEncoding");
	if (pGetStringEncoding) return pGetStringEncoding(str);
	else return (unsigned long)0;
}

void REALSetStringEncoding(REALstring str, unsigned long encoding)
{
	static void (*pSetStringEncoding)(REALstring, unsigned long) = nil;
	if (!pSetStringEncoding)
		pSetStringEncoding = (void (*)(REALstring, unsigned long)) CallResolver("REALSetStringEncoding");
	if (pSetStringEncoding) pSetStringEncoding(str, encoding);
}

#if TARGET_PPC || TARGET_CARBON
Boolean REALFSRefFromFolderItem(REALfolderItem f, FSRef*outRef, HFSUniStr255*outName)
{
	static Boolean (*pFSRefFromFolderItem)(REALfolderItem, FSRef*, HFSUniStr255*) = nil;
	if (!pFSRefFromFolderItem)
		pFSRefFromFolderItem = (Boolean (*)(REALfolderItem, FSRef*, HFSUniStr255*)) CallResolver("REALFSRefFromFolderItem");
	if (pFSRefFromFolderItem) return pFSRefFromFolderItem(f, outRef, outName);
	else return (Boolean)0;
}
#endif

#if TARGET_PPC || TARGET_CARBON
	#if FLAT_C_PLUGIN_HEADERS
		REALfolderItem REALFolderItemFromParentFSRef(const FSRef *parent, const HFSUniStr255 *fileName)
		{
			static REALfolderItem (*pFolderItemFromParentFSRef)(const FSRef*, const HFSUniStr255*) = nil;
			if (!pFolderItemFromParentFSRef)
				pFolderItemFromParentFSRef = (REALfolderItem (*)(const FSRef*, const HFSUniStr255*)) CallResolver("REALFolderItemFromParentFSRef");
			if (pFolderItemFromParentFSRef) return pFolderItemFromParentFSRef(parent, fileName);
			else return (REALfolderItem)0;
		}
	#else
		REALfolderItem REALFolderItemFromParentFSRef(const FSRef& parent, const HFSUniStr255& fileName)
		{
			static REALfolderItem (*pFolderItemFromParentFSRef)(const FSRef&, const HFSUniStr255&) = nil;
			if (!pFolderItemFromParentFSRef)
				pFolderItemFromParentFSRef = (REALfolderItem (*)(const FSRef&, const HFSUniStr255&)) CallResolver("REALFolderItemFromParentFSRef");
			if (pFolderItemFromParentFSRef) return pFolderItemFromParentFSRef(parent, fileName);
			else return (REALfolderItem)0;
		}
	#endif
#endif

REALDBConnectionDialogRef REALDBConnectionDialogCreate(void)
{
	static REALDBConnectionDialogRef (*pDBConnectionDialogCreate)(void) = nil;
	if (!pDBConnectionDialogCreate)
		pDBConnectionDialogCreate = (REALDBConnectionDialogRef (*)(void)) CallResolver("REALDBConnectionDialogCreate");
	if (pDBConnectionDialogCreate) return pDBConnectionDialogCreate();
	else return (REALDBConnectionDialogRef)0;
}

void REALDBConnectionDialogAddField(REALDBConnectionDialogRef dialogRef, REALstring label, REALstring defaultText, Boolean maskField)
{
	static void (*pDBConnectionDialogAddField)(REALDBConnectionDialogRef, REALstring, REALstring, Boolean) = nil;
	if (!pDBConnectionDialogAddField)
		pDBConnectionDialogAddField = (void (*)(REALDBConnectionDialogRef, REALstring, REALstring, Boolean)) CallResolver("REALDBConnectionDialogAddField");
	if (pDBConnectionDialogAddField) pDBConnectionDialogAddField(dialogRef, label, defaultText, maskField);
}

REALstring REALDBConnectionDialogShow(REALDBConnectionDialogRef dialogRef, REALstring title)
{
	static REALstring (*pDBConnectionDialogShow)(REALDBConnectionDialogRef, REALstring) = nil;
	if (!pDBConnectionDialogShow)
		pDBConnectionDialogShow = (REALstring (*)(REALDBConnectionDialogRef, REALstring)) CallResolver("REALDBConnectionDialogShow");
	if (pDBConnectionDialogShow) return pDBConnectionDialogShow(dialogRef, title);
	else return (REALstring)0;
}

void REALDBConnectionDialogDelete(REALDBConnectionDialogRef dialogRef)
{
	static void (*pDBConnectionDialogDelete)(REALDBConnectionDialogRef) = nil;
	if (!pDBConnectionDialogDelete)
		pDBConnectionDialogDelete = (void (*)(REALDBConnectionDialogRef)) CallResolver("REALDBConnectionDialogDelete");
	if (pDBConnectionDialogDelete) pDBConnectionDialogDelete(dialogRef);
}

REALstring REALGetControlName(REALcontrolInstance control)
{
	static REALstring (*pGetControlName)(REALcontrolInstance) = nil;
	if (!pGetControlName)
		pGetControlName = (REALstring (*)(REALcontrolInstance)) CallResolver("REALGetControlName");
	if (pGetControlName) return pGetControlName(control);
	else return (REALstring)0;
}

Boolean REALIsHIViewWindow(REALwindow window)
{
	static Boolean (*pIsHIViewWindow)(REALwindow) = nil;
	if (!pIsHIViewWindow)
		pIsHIViewWindow = (Boolean (*)(REALwindow)) CallResolver("REALIsHIViewWindow");
	if (pIsHIViewWindow) return pIsHIViewWindow(window);
	else return (Boolean)0;
}

#if TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || X_WINDOW || TARGET_COCOA
REALpicture REALBuildPictureFromBuffer(long width, long height, RBPixelType pixelType, void*buffer, long rowBytes)
{
	static unsigned long (*pBuildPictureFromBuffer)(long, long, RBPixelType, void*, long) = nil;
	if (!pBuildPictureFromBuffer)
		pBuildPictureFromBuffer = (unsigned long (*)(long, long, RBPixelType, void*, long)) CallResolver("REALBuildPictureFromBuffer");
	if (pBuildPictureFromBuffer) return (REALpicture)pBuildPictureFromBuffer(width, height, pixelType, buffer, rowBytes);
	else return (REALpicture)0;
}
#endif

#if TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || X_WINDOW || TARGET_COCOA
unsigned long REALGetFontEncoding(const char *fontName)
{
	static unsigned long (*pGetFontEncoding)(const char *) = nil;
	if (!pGetFontEncoding)
		pGetFontEncoding = (unsigned long (*)(const char *)) CallResolver("REALGetFontEncoding");
	if (pGetFontEncoding) return pGetFontEncoding(fontName);
	else return (unsigned long)0;
}
#endif

REALstring REALConvertString(REALstring str, unsigned long encoding)
{
	static REALstring (*pConvertString)(REALstring, unsigned long) = nil;
	if (!pConvertString)
		pConvertString = (REALstring (*)(REALstring, unsigned long)) CallResolver("REALConvertString");
	if (pConvertString) return pConvertString(str, encoding);
	else return (REALstring)0;
}

#if TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || X_WINDOW || TARGET_COCOA
REALpicture REALGetPictureMask(REALpicture pict, Boolean createIfNil)
{
	static REALpicture (*pGetPictureMask)(REALpicture, Boolean) = nil;
	if (!pGetPictureMask)
		pGetPictureMask = (REALpicture (*)(REALpicture, Boolean)) CallResolver("REALGetPictureMask");
	if (pGetPictureMask) return pGetPictureMask(pict, createIfNil);
	else return (REALpicture)0;
}
#endif

#if TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || X_WINDOW || TARGET_COCOA
Boolean REALInDebugMode(void)
{
	static Boolean (*pInDebugMode)(void) = nil;
	if (!pInDebugMode)
		pInDebugMode = (Boolean (*)(void)) CallResolver("REALInDebugMode");
	if (pInDebugMode) return pInDebugMode();
	else return (Boolean)0;
}
#endif

#if TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || X_WINDOW || TARGET_COCOA
void REALGraphicsDrawString(REALgraphics graphics, REALstring str, long x, long y, long width)
{
	static void (*pGraphicsDrawString)(REALgraphics, REALstring, long, long, long) = nil;
	if (!pGraphicsDrawString)
		pGraphicsDrawString = (void (*)(REALgraphics, REALstring, long, long, long)) CallResolver("RuntimeGraphicsDrawString");
	if (pGraphicsDrawString) pGraphicsDrawString(graphics, str, x, y, width);
}
#endif

#if TARGET_CARBON || TARGET_COCOA
CFStringRef REALGetStringCFString(REALstring str, Boolean stripAmpersands)
{
	static CFStringRef (*pGetStringCFString)(REALstring, Boolean) = nil;
	if (!pGetStringCFString)
		pGetStringCFString = (CFStringRef (*)(REALstring, Boolean)) CallResolver("REALGetStringCFString");
	if (pGetStringCFString) return pGetStringCFString(str, stripAmpersands);
	else return (CFStringRef)0;
}
#endif

#if TARGET_PPC || TARGET_CARBON || TARGET_COCOA
void REALGetStringSystemStr(REALstring str, Boolean stripAmpersands, Str255 outStr255)
{
	static void (*pGetStringSystemStr)(REALstring, Boolean, Str255) = nil;
	if (!pGetStringSystemStr)
		pGetStringSystemStr = (void (*)(REALstring, Boolean, Str255)) CallResolver("REALGetStringSystemStr");
	if (pGetStringSystemStr) pGetStringSystemStr(str, stripAmpersands, outStr255);
}
#endif

#if TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || X_WINDOW || TARGET_COCOA
void REALGetGraphicsFontStyle(REALgraphics graphics, REALfontStyle*  outStyle)
{
	static void (*pGetGraphicsFontStyle)(REALgraphics, REALfontStyle* ) = nil;
	if (!pGetGraphicsFontStyle)
		pGetGraphicsFontStyle = (void (*)(REALgraphics, REALfontStyle* )) CallResolver("REALGetGraphicsFontStyle");
	if (pGetGraphicsFontStyle) pGetGraphicsFontStyle(graphics, outStyle);
}
#endif

#if TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || X_WINDOW || TARGET_COCOA
void REALSetGraphicsStyle(REALgraphics graphics, REALfontStyle*  styleInfo)
{
	static void (*pSetGraphicsStyle)(REALgraphics, REALfontStyle* ) = nil;
	if (!pSetGraphicsStyle)
		pSetGraphicsStyle = (void (*)(REALgraphics, REALfontStyle* )) CallResolver("REALSetGraphicsStyle");
	if (pSetGraphicsStyle) pSetGraphicsStyle(graphics, styleInfo);
}
#endif

#if TARGET_PPC || TARGET_CARBON || TARGET_WIN32 || X_WINDOW || TARGET_COCOA
void REALStripAmpersands(REALstring*  ioString)
{
	static void (*pStripAmpersands)(REALstring* ) = nil;
	if (!pStripAmpersands)
		pStripAmpersands = (void (*)(REALstring* )) CallResolver("REALStripAmpersands");
	if (pStripAmpersands) pStripAmpersands(ioString);
}
#endif

long REALGraphicsStringWidth(REALgraphics graphics, REALstring str)
{
	static int (*pGraphicsStringWidth)(REALgraphics, REALstring) = nil;
	if (!pGraphicsStringWidth)
		pGraphicsStringWidth = (int (*)(REALgraphics, REALstring)) CallResolver("RuntimeGraphicsStringWidth");
	if (pGraphicsStringWidth) return (long)pGraphicsStringWidth(graphics, str);
	else return (long)0;
}

long REALGraphicsStringHeight(REALgraphics graphics, REALstring str, long wrapWidth)
{
	static int (*pGraphicsStringHeight)(REALgraphics, REALstring, long) = nil;
	if (!pGraphicsStringHeight)
		pGraphicsStringHeight = (int (*)(REALgraphics, REALstring, long)) CallResolver("RuntimeGraphicsStringHeight");
	if (pGraphicsStringHeight) return (long)pGraphicsStringHeight(graphics, str, wrapWidth);
	else return (long)0;
}

long REALGraphicsTextHeight(REALgraphics graphics)
{
	static int (*pGraphicsTextHeight)(REALgraphics) = nil;
	if (!pGraphicsTextHeight)
		pGraphicsTextHeight = (int (*)(REALgraphics)) CallResolver("RuntimeGraphicsTextHeight");
	if (pGraphicsTextHeight) return (long)pGraphicsTextHeight(graphics);
	else return (long)0;
}

long REALGraphicsTextAscent(REALgraphics graphics)
{
	static int (*pGraphicsTextAscent)(REALgraphics) = nil;
	if (!pGraphicsTextAscent)
		pGraphicsTextAscent = (int (*)(REALgraphics)) CallResolver("RuntimeGraphicsTextAscent");
	if (pGraphicsTextAscent) return (long)pGraphicsTextAscent(graphics);
	else return (long)0;
}

#if (TARGET_PPC || TARGET_CARBON) && !TARGET_COCOA
void REALReleasePopupMenuHandle(REALpopupMenu popup)
{
	static void (*pReleasePopupMenuHandle)(REALpopupMenu) = nil;
	if (!pReleasePopupMenuHandle)
		pReleasePopupMenuHandle = (void (*)(REALpopupMenu)) CallResolver("REALReleasePopupMenuHandle");
	if (pReleasePopupMenuHandle) pReleasePopupMenuHandle(popup);
}
#endif

void REALSocketListen(REALsocket socket)
{
	static void (*pSocketListen)(REALsocket) = nil;
	if (!pSocketListen)
		pSocketListen = (void (*)(REALsocket)) CallResolver("pluginSocketListen");
	if (pSocketListen) pSocketListen(socket);
}

REALfolderItem REALGetProjectFolder(void)
{
	static REALfolderItem (*pGetProjectFolder)(void) = nil;
	if (!pGetProjectFolder)
		pGetProjectFolder = (REALfolderItem (*)(void)) CallResolver("REALGetProjectFolder");
	if (pGetProjectFolder) return pGetProjectFolder();
	else return (REALfolderItem)0;
}

#if X_WINDOW
unsigned long REALGetControlHandle(REALcontrolInstance control)
{
	static unsigned long (*pGetControlHandle)(REALcontrolInstance) = nil;
	if (!pGetControlHandle)
		pGetControlHandle = (unsigned long (*)(REALcontrolInstance)) CallResolver("REALGetControlHandle");
	if (pGetControlHandle) return pGetControlHandle(control);
	else return (unsigned long)0;
}
#endif

#if X_WINDOW
unsigned long REALGraphicsDC(REALgraphics context)
{
	static unsigned long (*pGraphicsDC)(REALgraphics) = nil;
	if (!pGraphicsDC)
		pGraphicsDC = (unsigned long (*)(REALgraphics)) CallResolver("REALGraphicsDC");
	if (pGraphicsDC) return pGraphicsDC(context);
	else return (unsigned long)0;
}
#endif

#if X_WINDOW
void REALDrawPicturePrimitive(REALgraphics context, REALpicture pic, const Rect *rBounds, int bTransparent)
{
	static void (*pDrawPicturePrimitive)(REALgraphics, REALpicture, const Rect *, int) = nil;
	if (!pDrawPicturePrimitive)
		pDrawPicturePrimitive = (void (*)(REALgraphics, REALpicture, const Rect *, int)) CallResolver("REALDrawPicturePrimitive");
	if (pDrawPicturePrimitive) pDrawPicturePrimitive(context, pic, rBounds, bTransparent);
}
#endif

void REALRegisterModule(REALmoduleDefinition*defn)
{
	static void (*pRegisterModule)(REALmoduleDefinition*) = nil;
	if (!pRegisterModule)
		pRegisterModule = (void (*)(REALmoduleDefinition*)) CallResolver("PluginRegisterModule");
	
	if (REALGetRBVersion() < 5.9) {
	  defn->methods = ConvertCurrentMethodsToV6( defn->methods, defn->methodCount );
	}
	
	if (pRegisterModule) pRegisterModule(defn);
}

void*REALLoadGlobalMethod(const char *module, const char *prototype)
{
	static void*(*pLoadGlobalMethod)(const char *, const char *) = nil;
	if (!pLoadGlobalMethod)
		pLoadGlobalMethod = (void*(*)(const char *, const char *)) CallResolver("REALLoadGlobalMethod");
	if (pLoadGlobalMethod) return pLoadGlobalMethod(module, prototype);
	else return (void*)0;
}

void*REALLoadObjectMethod(REALobject object, const char *prototype)
{
	static void*(*pLoadObjectMethod)(REALobject, const char *) = nil;
	if (!pLoadObjectMethod)
		pLoadObjectMethod = (void*(*)(REALobject, const char *)) CallResolver("REALLoadObjectMethod");
	if (pLoadObjectMethod) return pLoadObjectMethod(object, prototype);
	else return (void*)0;
}

Boolean REALGetPropValueInt32(REALobject object, const char *propName, long *outValue)
{
	static long (*pGetPropValue)(REALobject, const char *, long *) = nil;
	if (!pGetPropValue)
		pGetPropValue = (long (*)(REALobject, const char *, long *)) CallResolver("REALGetPropValueInt");
	if (pGetPropValue) return (Boolean)pGetPropValue(object, propName, outValue);
	else return (Boolean)0;
}

Boolean REALGetPropValueString(REALobject object, const char *propName, REALstring *outValue)
{
	static long (*pGetPropValue)(REALobject, const char *, REALstring *) = nil;
	if (!pGetPropValue)
		pGetPropValue = (long (*)(REALobject, const char *, REALstring *)) CallResolver("REALGetPropValueString");
	if (pGetPropValue) return (Boolean)pGetPropValue(object, propName, outValue);
	else return (Boolean)0;
}

Boolean REALGetPropValueDouble(REALobject object, const char *propName, double *outValue)
{
	static long (*pGetPropValue)(REALobject, const char *, double *) = nil;
	if (!pGetPropValue)
		pGetPropValue = (long (*)(REALobject, const char *, double *)) CallResolver("REALGetPropValueDouble");
	if (pGetPropValue) return (Boolean)pGetPropValue(object, propName, outValue);
	else return (Boolean)0;
}

Boolean REALGetPropValueObject(REALobject object, const char *propName, REALobject *outValue)
{
	static long (*pGetPropValue)(REALobject, const char *, REALobject *) = nil;
	if (!pGetPropValue)
		pGetPropValue = (long (*)(REALobject, const char *, REALobject *)) CallResolver("REALGetPropValueObject");
	if (pGetPropValue) return (Boolean)pGetPropValue(object, propName, outValue);
	else return (Boolean)0;
}

void REALSetDBIsConnected(REALdbDatabase database, Boolean connected)
{
	static void (*pSetDBIsConnected)(REALdbDatabase, Boolean) = nil;
	if (!pSetDBIsConnected)
		pSetDBIsConnected = (void (*)(REALdbDatabase, Boolean)) CallResolver("REALSetDBIsConnected");
	if (pSetDBIsConnected) pSetDBIsConnected(database, connected);
}

REALobject REALNewVariantString(REALstring value)
{
	static REALobject (*pNewVariantString)(REALstring) = nil;
	if (!pNewVariantString)
		pNewVariantString = (REALobject (*)(REALstring)) CallResolver("StringToVariant");
	if (pNewVariantString) return pNewVariantString(value);
	else return (REALobject)0;
}

REALobject REALNewVariantInteger(long value)
{
	static REALobject (*pNewVariantInteger)(long) = nil;
	if (!pNewVariantInteger)
		pNewVariantInteger = (REALobject (*)(long)) CallResolver("Int32ToVariant");
	if (pNewVariantInteger) return pNewVariantInteger(value);
	else return (REALobject)0;
}

REALobject REALNewVariantDouble(double value)
{
	static REALobject (*pNewVariantDouble)(double) = nil;
	if (!pNewVariantDouble)
		pNewVariantDouble = (REALobject (*)(double)) CallResolver("DoubleToVariant");
	if (pNewVariantDouble) return pNewVariantDouble(value);
	else return (REALobject)0;
}

REALobject REALNewVariantBoolean(Boolean value)
{
	static REALobject (*pNewVariantBoolean)(Boolean) = nil;
	if (!pNewVariantBoolean)
		pNewVariantBoolean = (REALobject (*)(Boolean)) CallResolver("BooleanToVariant");
	if (pNewVariantBoolean) return pNewVariantBoolean(value);
	else return (REALobject)0;
}

REALobject REALNewVariantColor(long value)
{
	static REALobject (*pNewVariantColor)(long) = nil;
	if (!pNewVariantColor)
		pNewVariantColor = (REALobject (*)(long)) CallResolver("ColorToVariant");
	if (pNewVariantColor) return pNewVariantColor(value);
	else return (REALobject)0;
}

Boolean REALSetPropValueInt32(REALobject object, const char *propName, long value)
{
	static long (*pSetPropValue)(REALobject, const char *, long) = nil;
	if (!pSetPropValue)
		pSetPropValue = (long (*)(REALobject, const char *, long)) CallResolver("REALSetPropValueInt");
	if (pSetPropValue) return (Boolean)pSetPropValue(object, propName, value);
	else return (Boolean)0;
}

Boolean REALSetPropValueString(REALobject object, const char *propName, REALstring value)
{
	static long (*pSetPropValue)(REALobject, const char *, REALstring) = nil;
	if (!pSetPropValue)
		pSetPropValue = (long (*)(REALobject, const char *, REALstring)) CallResolver("REALSetPropValueString");
	if (pSetPropValue) return (Boolean)pSetPropValue(object, propName, value);
	else return (Boolean)0;
}

Boolean REALSetPropValueDouble(REALobject object, const char *propName, double value)
{
	static long (*pSetPropValue)(REALobject, const char *, double) = nil;
	if (!pSetPropValue)
		pSetPropValue = (long (*)(REALobject, const char *, double)) CallResolver("REALSetPropValueDouble");
	if (pSetPropValue) return (Boolean)pSetPropValue(object, propName, value);
	else return (Boolean)0;
}

Boolean REALSetPropValueObject(REALobject object, const char *propName, REALobject value)
{
	static long (*pSetPropValue)(REALobject, const char *, REALobject) = nil;
	if (!pSetPropValue)
		pSetPropValue = (long (*)(REALobject, const char *, REALobject)) CallResolver("REALSetPropValueObject");
	if (pSetPropValue) return (Boolean)pSetPropValue(object, propName, value);
	else return (Boolean)0;
}

#if X_WINDOW
void *REALGraphicsGdkDrawable(REALgraphics context)
{
	static void *(*pGraphicsGdkDrawable)(REALgraphics) = nil;
	if (!pGraphicsGdkDrawable)
		pGraphicsGdkDrawable = (void *(*)(REALgraphics)) CallResolver("REALGraphicsGdkDrawable");
	if (pGraphicsGdkDrawable) return pGraphicsGdkDrawable(context);
	else return (void *)0;
}
#endif

#if TARGET_WIN32
REALgraphics REALGetControlGraphics(REALcontrolInstance instance, HDC dc)
{
	static unsigned long (*pGetControlGraphics)(REALcontrolInstance, HDC) = nil;
	if (!pGetControlGraphics)
		pGetControlGraphics = (unsigned long (*)(REALcontrolInstance, HDC)) CallResolver("REALGetControlGraphicsWithDC");
	if (pGetControlGraphics) return (REALgraphics)pGetControlGraphics(instance, dc);
	else return (REALgraphics)0;
}
#endif

dbCursor *REALGetCursorFromREALdbCursor(REALdbCursor cursor)
{
	static dbCursor *(*pGetCursorFromREALdbCursor)(REALdbCursor) = nil;
	if (!pGetCursorFromREALdbCursor)
		pGetCursorFromREALdbCursor = (dbCursor *(*)(REALdbCursor)) CallResolver("REALGetCursorFromREALdbCursor");
	if (pGetCursorFromREALdbCursor) return pGetCursorFromREALdbCursor(cursor);
	else return (dbCursor *)0;
}

Boolean REALLockPictureDescription(REALpicture pic, REALpictureDescription *description, long picType)
{
	static Boolean (*pLockPictureDescription)(REALpicture, REALpictureDescription *, long) = nil;
	if (!pLockPictureDescription)
		pLockPictureDescription = (Boolean (*)(REALpicture, REALpictureDescription *, long)) CallResolver("REALLockPictureDescription");
	if (pLockPictureDescription) return pLockPictureDescription(pic, description, picType);
	else return (Boolean)0;
}

#if X_WINDOW
unsigned long REALGetWindowHandle(REALwindow window)
{
	static unsigned long (*pGetWindowHandle)(REALwindow) = nil;
	if (!pGetWindowHandle)
		pGetWindowHandle = (unsigned long (*)(REALwindow)) CallResolver("REALGetWindowHandle");
	if (pGetWindowHandle) return pGetWindowHandle(window);
	else return (unsigned long)0;
}
#endif

void REALGetGraphicsOrigin(REALgraphics context, long *originX, long *originY)
{
	static void (*pGetGraphicsOrigin)(REALgraphics, long *, long *) = nil;
	if (!pGetGraphicsOrigin)
		pGetGraphicsOrigin = (void (*)(REALgraphics, long *, long *)) CallResolver("REALGetGraphicsOrigin");
	if (pGetGraphicsOrigin) pGetGraphicsOrigin(context, originX, originY);
}

void REALSetGraphicsOrigin(REALgraphics context, long originX, long originY)
{
	static void (*pSetGraphicsOrigin)(REALgraphics, long, long) = nil;
	if (!pSetGraphicsOrigin)
		pSetGraphicsOrigin = (void (*)(REALgraphics, long, long)) CallResolver("REALSetGraphicsOrigin");
	if (pSetGraphicsOrigin) pSetGraphicsOrigin(context, originX, originY);
}

#if TARGET_CARBON || TARGET_WIN32 || X_WINDOW
void SetClassConsoleSafe(REALclassDefinition def)
{
	static void (*pSetClassConsoleSafe)(REALclassDefinition) = nil;
	if (!pSetClassConsoleSafe)
		pSetClassConsoleSafe = (void (*)(REALclassDefinition)) CallResolver("");
	if (pSetClassConsoleSafe) pSetClassConsoleSafe(def);
}
#endif

REALobject REALNewVariantUInt32(unsigned long value)
{
	static REALobject (*pNewVariantUInt32)(unsigned long) = nil;
	if (!pNewVariantUInt32)
		pNewVariantUInt32 = (REALobject (*)(unsigned long)) CallResolver("UInt32ToVariant");
	if (pNewVariantUInt32) return pNewVariantUInt32(value);
	else return (REALobject)0;
}

REALobject REALNewVariantInt64(long long value)
{
	static REALobject (*pNewVariantInt64)(long long) = nil;
	if (!pNewVariantInt64)
		pNewVariantInt64 = (REALobject (*)(long long)) CallResolver("Int64ToVariant");
	if (pNewVariantInt64) return pNewVariantInt64(value);
	else return (REALobject)0;
}

REALobject REALNewVariantUInt64(unsigned long long value)
{
	static REALobject (*pNewVariantUInt64)(unsigned long long) = nil;
	if (!pNewVariantUInt64)
		pNewVariantUInt64 = (REALobject (*)(unsigned long long)) CallResolver("UInt64ToVariant");
	if (pNewVariantUInt64) return pNewVariantUInt64(value);
	else return (REALobject)0;
}

REALobject REALNewVariantSingle(float value)
{
	static REALobject (*pNewVariantSingle)(float) = nil;
	if (!pNewVariantSingle)
		pNewVariantSingle = (REALobject (*)(float)) CallResolver("SingleToVariant");
	if (pNewVariantSingle) return pNewVariantSingle(value);
	else return (REALobject)0;
}

REALobject REALNewVariantCurrency(REALcurrency value)
{
	static REALobject (*pNewVariantCurrency)(REALcurrency) = nil;
	if (!pNewVariantCurrency)
		pNewVariantCurrency = (REALobject (*)(REALcurrency)) CallResolver("CurrencyToVariant");
	if (pNewVariantCurrency) return pNewVariantCurrency(value);
	else return (REALobject)0;
}

Boolean REALGetPropValueInt64(REALobject object, const char *name, long long *value)
{
	static long (*pGetPropValue)(REALobject, const char *, long long *) = nil;
	if (!pGetPropValue)
		pGetPropValue = (long (*)(REALobject, const char *, long long *)) CallResolver("REALGetPropValueInt64");
	if (pGetPropValue) return (Boolean)pGetPropValue(object, name, value);
	else return (Boolean)0;
}

Boolean REALGetPropValueUInt64(REALobject object, const char *param, unsigned long long *value)
{
	static long (*pGetPropValue)(REALobject, const char *, unsigned long long *) = nil;
	if (!pGetPropValue)
		pGetPropValue = (long (*)(REALobject, const char *, unsigned long long *)) CallResolver("REALGetPropValueUInt64");
	if (pGetPropValue) return (Boolean)pGetPropValue(object, param, value);
	else return (Boolean)0;
}

Boolean REALGetPropValueUInt32(REALobject object, const char *name, unsigned long *value)
{
	static long (*pGetPropValue)(REALobject, const char *, unsigned long *) = nil;
	if (!pGetPropValue)
		pGetPropValue = (long (*)(REALobject, const char *, unsigned long *)) CallResolver("REALGetPropValueUInt32");
	if (pGetPropValue) return (Boolean)pGetPropValue(object, name, value);
	else return (Boolean)0;
}

Boolean REALGetPropValueUInt16(REALobject object, const char *name, unsigned short *value)
{
	static long (*pGetPropValue)(REALobject, const char *, unsigned short *) = nil;
	if (!pGetPropValue)
		pGetPropValue = (long (*)(REALobject, const char *, unsigned short *)) CallResolver("REALGetPropValueUInt16");
	if (pGetPropValue) return (Boolean)pGetPropValue(object, name, value);
	else return (Boolean)0;
}

Boolean REALGetPropValueInt16(REALobject object, const char *name, short *value)
{
	static long (*pGetPropValue)(REALobject, const char *, short *) = nil;
	if (!pGetPropValue)
		pGetPropValue = (long (*)(REALobject, const char *, short *)) CallResolver("REALGetPropValueInt16");
	if (pGetPropValue) return (Boolean)pGetPropValue(object, name, value);
	else return (Boolean)0;
}

Boolean REALGetPropValueInt8(REALobject object, const char *name, char *value)
{
	static long (*pGetPropValue)(REALobject, const char *, char *) = nil;
	if (!pGetPropValue)
		pGetPropValue = (long (*)(REALobject, const char *, char *)) CallResolver("REALGetPropValueInt8");
	if (pGetPropValue) return (Boolean)pGetPropValue(object, name, value);
	else return (Boolean)0;
}

Boolean REALGetPropValueUInt8(REALobject object, const char *name, unsigned char *value)
{
	static long (*pGetPropValue)(REALobject, const char *, unsigned char *) = nil;
	if (!pGetPropValue)
		pGetPropValue = (long (*)(REALobject, const char *, unsigned char *)) CallResolver("REALGetPropValueBool");
	if (pGetPropValue) return (Boolean)pGetPropValue(object, name, value);
	else return (Boolean)0;
}

Boolean REALGetPropValueSingle(REALobject object, const char *name, float *value)
{
	static long (*pGetPropValue)(REALobject, const char *, float *) = nil;
	if (!pGetPropValue)
		pGetPropValue = (long (*)(REALobject, const char *, float *)) CallResolver("REALGetPropValueSingle");
	if (pGetPropValue) return (Boolean)pGetPropValue(object, name, value);
	else return (Boolean)0;
}

Boolean REALSetPropValueUInt32(REALobject object, const char *name, unsigned long value)
{
	static long (*pSetPropValue)(REALobject, const char *, unsigned long) = nil;
	if (!pSetPropValue)
		pSetPropValue = (long (*)(REALobject, const char *, unsigned long)) CallResolver("REALSetPropValueUInt32");
	if (pSetPropValue) return (Boolean)pSetPropValue(object, name, value);
	else return (Boolean)0;
}

Boolean REALSetPropValueUInt64(REALobject object, const char *name, unsigned long long value)
{
	static long (*pSetPropValue)(REALobject, const char *, unsigned long long) = nil;
	if (!pSetPropValue)
		pSetPropValue = (long (*)(REALobject, const char *, unsigned long long)) CallResolver("REALSetPropValueUInt64");
	if (pSetPropValue) return (Boolean)pSetPropValue(object, name, value);
	else return (Boolean)0;
}

Boolean REALSetPropValueInt64(REALobject object, const char *name, long long value)
{
	static long (*pSetPropValue)(REALobject, const char *, long long) = nil;
	if (!pSetPropValue)
		pSetPropValue = (long (*)(REALobject, const char *, long long)) CallResolver("REALSetPropValueInt64");
	if (pSetPropValue) return (Boolean)pSetPropValue(object, name, value);
	else return (Boolean)0;
}

Boolean REALSetPropValueInt16(REALobject object, const char *name, short value)
{
	static long (*pSetPropValue)(REALobject, const char *, short) = nil;
	if (!pSetPropValue)
		pSetPropValue = (long (*)(REALobject, const char *, short)) CallResolver("REALSetPropValueInt16");
	if (pSetPropValue) return (Boolean)pSetPropValue(object, name, value);
	else return (Boolean)0;
}

Boolean REALSetPropValueUInt16(REALobject object, const char *name, unsigned short value)
{
	static long (*pSetPropValue)(REALobject, const char *, unsigned short) = nil;
	if (!pSetPropValue)
		pSetPropValue = (long (*)(REALobject, const char *, unsigned short)) CallResolver("REALSetPropValueUInt16");
	if (pSetPropValue) return (Boolean)pSetPropValue(object, name, value);
	else return (Boolean)0;
}

Boolean REALSetPropValueInt8(REALobject object, const char *name, char value)
{
	static long (*pSetPropValue)(REALobject, const char *, char) = nil;
	if (!pSetPropValue)
		pSetPropValue = (long (*)(REALobject, const char *, char)) CallResolver("REALSetPropValueInt8");
	if (pSetPropValue) return (Boolean)pSetPropValue(object, name, value);
	else return (Boolean)0;
}

Boolean REALSetPropValueUInt8(REALobject object, const char *name, unsigned char value)
{
	static long (*pSetPropValue)(REALobject, const char *, unsigned char) = nil;
	if (!pSetPropValue)
		pSetPropValue = (long (*)(REALobject, const char *, unsigned char)) CallResolver("REALSetPropValueBoolean");
	if (pSetPropValue) return (Boolean)pSetPropValue(object, name, value);
	else return (Boolean)0;
}

Boolean REALSetPropValueSingle(REALobject object, const char *name, float value)
{
	static long (*pSetPropValue)(REALobject, const char *, float) = nil;
	if (!pSetPropValue)
		pSetPropValue = (long (*)(REALobject, const char *, float)) CallResolver("REALSetPropValueSingle");
	if (pSetPropValue) return (Boolean)pSetPropValue(object, name, value);
	else return (Boolean)0;
}

// **** Autogenerated code from Plugin API Manager ends here ****
// **************** Do not edit above this line *****************
#pragma mark -
#pragma mark PAM Code Above!
#pragma mark -

long REALstringToOSType(REALstring id)
{
	static bool isLittleEndian;
	static bool isInited;
	if (!isInited) {
		long test = 1;
		if (*(char *)&test == 1) {
			isLittleEndian = true;
		} else {
			isLittleEndian = false;
		}
	}
	long rv = '    ';
	int count = id->Length();
	if (count > 4) count = 4;
	const char *in = id->CString();
	char *out = (char*)(&rv);
	if (isLittleEndian) {
		// Little endian
		for (int i=0; i<count; i++) {
			out[i] = in[3 - i];
		}
	} else {
		// Big endian
		for (int i=0; i<count; i++) out[i] = in[i];
	}
	return rv;
}

long REALstringStruct::Length(void)
{
	if (this)
		return mPrivateLength;
	else
		return 0;
}

const char *REALstringStruct::CString()
{
	if (this)
		return (const char *) (mPrivateStringData + 1);
	else
		return "";
}

const unsigned char *REALstringStruct::PString()
{
	if (this)
		return mPrivateStringData;
	else {
		#if _MSC_VER
			return (unsigned char *)"\0";
		#else
			return (unsigned char *)"\p";
		#endif
	}
}

// declare the global initialization function (generated automatically by the linker)
#if !NOSTATICINIT
	#if TARGET_CPU_PPC
		extern "C" void __sinit(void);
	#elif TARGET_68K
		extern "C" far void __InitCode__(void);
	#endif
#endif

void* HCallResolver(const char *entryName);
void* HCallResolver(const char *entryName) { return CallResolver(entryName); }

// Main program

#ifdef WIN32
extern "C" {
void __declspec(dllexport) REALPluginMain(void *(*resolver)(const char *entryName));
}

void __declspec(dllexport) REALPluginMain(void *(*resolver)(const char *entryName))
#elif UNIX_ANSI or TARGET_RT_MAC_MACHO
extern "C" {
#if __MWERKS__
	#pragma export on
#endif
	void REALPluginMain(void *(*resolver)(const char *entryName));
#if __MWERKS__
	#pragma export off
#endif
}

void REALPluginMain(void *(*resolver)(const char *entryName))
#else
void main(void *(*resolver)(const char *entryName))
#endif
{
//	void (*pRegisterPluginExports)(REALexport *table);
	void (*pRegisterPluginVersion)(int version);

	#if TARGET_68K
		EnterCodeResource();
	#endif

	// invoke the global initialization function
	#if TARGET_OS_MAC
		#if !NOSTATICINIT
			#if TARGET_CPU_PPC
				__sinit();
			#elif TARGET_68K
			 	__InitCode__();
			#endif
		#endif
	#endif

	gResolver = resolver;

#ifdef USECALLSHELL
	unsigned long (*getA4stack)(void);

	getA4stack = (unsigned long(*)(void)) resolver("getA4stackReference");
	a4stack = getA4stack();
#else
#if TARGET_OS_MAC && powerc
 #if CARBON || TARGET_COCOA
 	gResolverPPC = (void *(*)(const char *)) gResolver("ResolverPPC");
 #else
	gResolverPPC = (void *(*)(const char *)) CallUniversalProc((RoutineDescriptor *) gResolver, kThinkCStackBased | RESULT_SIZE(SIZE_CODE(4)) | STACK_ROUTINE_PARAMETER(1, SIZE_CODE(4)), "ResolverPPC");
 #endif
#endif
#endif

//	pRegisterPluginExports = (void (*)(REALexport *)) CallResolver("RegisterPluginExports");
//	pRegisterPluginExports(pluginExports);

	pRegisterPluginVersion = (void (*)(int)) CallResolver("RegisterPluginVersion");
	pRegisterPluginVersion(kCurrentREALControlVersion);

	PluginEntry();

	#if TARGET_68K
		ExitCodeResource();
	#endif
}

#if TARGET_68K
// Because of our atypical calling conventions, the standard
// new/delete operators do not work correctly on 68k.  We
// implement these custom ones that just call through to MacOS
// memory manager functions.
#pragma d0_pointers off
void *operator new(unsigned long size)
{
	return NewPtr(size);
}

void operator delete(void *ptr)
{
	DisposePtr((Ptr)ptr);
}

void *operator new[](unsigned long size)
{
	return NewPtr(size);
}

void operator delete[](void *ptr)
{
	DisposePtr((Ptr)ptr);
}
#endif


